/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaCatalogDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.TrinoQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;

public class TrinoDBMetadataProvider
extends DefaultSchemaCatalogDBMetadataProvider {
    private static final ImmutableList<String> IGNORED_SCHEMAS = ImmutableList.of((Object)"information_schema");
    private static final ImmutableList<String> IGNORED_CATALOGS = ImmutableList.of((Object)"system");

    @AssistedInject
    TrinoDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new TrinoQuotedIDFactory(), coreSingletons);
    }

    @Override
    protected boolean isRelationExcluded(RelationID id) {
        return IGNORED_SCHEMAS.contains((Object)this.getRelationSchema(id)) || IGNORED_CATALOGS.contains((Object)this.getRelationCatalog(id));
    }

    @Override
    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
    }
}

