/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import it.unibz.inf.ontop.dbschema.impl.SparkSQLQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSQLDBMetadataProvider
extends AbstractDBMetadataProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SparkSQLDBMetadataProvider.class);
    protected static final int SCHEMA_INDEX = 1;
    protected static final int CATALOG_INDEX = 2;
    private final @Nullable QuotedID defaultCatalog;
    private final QuotedID defaultSchema;

    @AssistedInject
    SparkSQLDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SparkSQLQuotedIDFactory(), coreSingletons);
        try {
            Object[] defaultRelationComponents;
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            LOGGER.info("OBTAINED FROM SPARK JDBC DRIVER: " + catalog + ", " + schema);
            if (catalog.isEmpty()) {
                catalog = null;
            }
            if ((defaultRelationComponents = new String[]{catalog, schema, "DUMMY"})[1] == null) {
                throw new MetadataExtractionException("Unable to obtain the default schema: make sure the connection URL is complete " + Arrays.toString(defaultRelationComponents));
            }
            RelationID id = this.rawIdFactory.createRelationID((String[])defaultRelationComponents);
            this.defaultCatalog = this.getCatalogID(id);
            this.defaultSchema = (QuotedID)id.getComponents().get(1);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) {
        switch (id.getComponents().size()) {
            case 2: {
                return this.getRelationIDWithDefaultCatalog((QuotedID)id.getComponents().get(0), (QuotedID)id.getComponents().get(1));
            }
            case 1: {
                return this.getRelationIDWithDefaultCatalog((QuotedID)id.getComponents().get(0), this.defaultSchema);
            }
        }
        return id;
    }

    private RelationID getRelationIDWithDefaultCatalog(QuotedID table, QuotedID schema) {
        return this.defaultCatalog == null ? new RelationIDImpl(ImmutableList.of((Object)table, (Object)schema)) : new RelationIDImpl(ImmutableList.of((Object)table, (Object)schema, (Object)this.defaultCatalog));
    }

    @Override
    protected ResultSet getRelationIDsResultSet() throws SQLException {
        if (this.getSettings().exposeSystemTables()) {
            try {
                Statement stmt = this.connection.createStatement();
                stmt.closeOnCompletion();
                return stmt.executeQuery("SELECT table_catalog as TABLE_CAT, table_schema as TABLE_SCHEM, TABLE_NAME from system.information_schema.tables WHERE table_type in ('TABLE', 'VIEW', 'EXTERNAL')");
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to load system tables due to SQLException: " + e.getMessage());
            }
        }
        return this.metadata.getTables(null, null, null, new String[]{"TABLE", "VIEW", "SYSTEM"});
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        if (Objects.equals(this.defaultCatalog, this.getCatalogID(id))) {
            RelationIDImpl schemaTableId = new RelationIDImpl(id.getComponents().subList(0, 2));
            if (this.defaultSchema.equals(id.getComponents().get(1))) {
                return ImmutableList.of((Object)id.getTableOnlyID(), (Object)schemaTableId, (Object)id);
            }
            return ImmutableList.of((Object)schemaTableId, (Object)id);
        }
        return ImmutableList.of((Object)id);
    }

    private QuotedID getCatalogID(RelationID id) {
        return id.getComponents().size() < 3 ? null : (QuotedID)id.getComponents().get(2);
    }

    @Override
    protected String getRelationCatalog(RelationID id) {
        QuotedID catalog = this.getCatalogID(id);
        if (catalog == null) {
            return null;
        }
        return catalog.getName();
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return ((QuotedID)id.getComponents().get(1)).getName();
    }

    @Override
    protected String getRelationName(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).getName();
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.rawIdFactory.createRelationID(new String[]{rs.getString(catalogNameColumn), rs.getString(schemaNameColumn), rs.getString(tableNameColumn)});
    }
}

