/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OracleDBMetadataProvider
extends DefaultSchemaDBMetadataProvider {
    private final RelationID sysDualId;
    private final boolean mapDateToTimestamp;
    private final boolean j2ee13Compliant;
    private final short versionNumber;
    private final boolean includeSynonyms;
    private static final int PREFETCH_SIZE = 4048;
    private static final ImmutableSet<String> IGNORED_TABLE_SCHEMAS = ImmutableSet.of((Object)"SYS", (Object)"GSMADMIN_INTERNAL", (Object)"OUTLN", (Object)"DBSNMP", (Object)"DBSFWUSER", (Object)"XDB", (Object[])new String[]{"CTXSYS", "MDSYS", "APPQOSSYS", "LBACSYS", "DVSYS", "APPQOSSYS", "WMSYS", "ORDDATA", "AUDSYS"});
    private static final ImmutableSet<String> IGNORED_TABLE_PREFIXES = ImmutableSet.of((Object)"MVIEW$_", (Object)"LOGMNR_", (Object)"AQ$_", (Object)"DEF$_", (Object)"REPCAT$_", (Object)"LOGSTDBY$", (Object[])new String[]{"OL$"});
    private static final ImmutableSet<String> IGNORED_SYSTEM_TABLES = ImmutableSet.of((Object)"ROLLING$DIRECTIVES", (Object)"SCHEDULER_JOB_ARGS_TBL", (Object)"REDO_DB", (Object)"REDO_LOG", (Object)"ROLLING$DATABASES", (Object)"ROLLING$EVENTS", (Object[])new String[]{"SCHEDULER_PROGRAM_ARGS", "REPL_SUPPORT_MATRIX", "ROLLING$PARAMETERS", "ROLLING$STATISTICS", "SCHEDULER_PROGRAM_ARGS_TBL", "PRODUCT_PRIVS", "SQLPLUS_PRODUCT_PROFILE", "REPL_VALID_COMPAT", "SCHEDULER_JOB_ARGS", "ROLLING$CONNECTIONS", "ROLLING$PLAN", "HELP", "ROLLING$STATUS"});
    private static final ImmutableSet<String> IGNORED_VIEW_PREFIXES = ImmutableSet.of((Object)"MVIEW_", (Object)"LOGMNR_AQ$_");
    private static final ImmutableSet<String> IGNORED_VIEW_SCHEMAS = ImmutableSet.of((Object)"SYS", (Object)"GSMADMIN_INTERNAL", (Object)"OUTLN", (Object)"DBSNMP", (Object)"DBSFWUSER", (Object)"XDB", (Object[])new String[]{"WMSYS", "CTXSYS", "ORDDATA", "ORDSYS", "OLAPSYS", "MDSYS", "LBACSYS", "DVSYS", "APPQOSSYS", "AUDSYS"});
    private static final ImmutableSet<String> IGNORED_SYSTEM_VIEWS = ImmutableSet.of((Object)"SCHEDULER_PROGRAM_ARGS", (Object)"SCHEDULER_JOB_ARGS", (Object)"PRODUCT_PRIVS");

    @AssistedInject
    protected OracleDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SQLStandardQuotedIDFactory(), coreSingletons);
        this.sysDualId = this.rawIdFactory.createRelationID("DUAL");
        this.versionNumber = OracleDBMetadataProvider.getProperty(connection, "getVersionNumber", null, null, (short)12000);
        this.mapDateToTimestamp = OracleDBMetadataProvider.getProperty(connection, "getMapDateToTimestamp", "oracle.jdbc.mapDateToTimestamp", Boolean::parseBoolean, true);
        this.j2ee13Compliant = OracleDBMetadataProvider.getProperty(connection, "getJ2EE13Compliant", "oracle.jdbc.J2EE13Compliant", Boolean::parseBoolean, true);
        this.includeSynonyms = OracleDBMetadataProvider.getProperty(connection, "getIncludeSynonyms", "includeSynonyms", Boolean::parseBoolean, false);
        LOGGER.debug("[DB-METADATA] Oracle version {} with mapDateToTimestamp {}, j2ee13Compliant {} and includeSynonyms {}", new Object[]{this.versionNumber, this.mapDateToTimestamp, this.j2ee13Compliant, this.includeSynonyms});
    }

    private static <T> T getProperty(Connection connection, String name, String property, Function<String, T> parser, T defValue) {
        try {
            Method m = connection.getClass().getMethod(name, new Class[0]);
            m.setAccessible(true);
            return (T)m.invoke((Object)connection, new Object[0]);
        }
        catch (Exception e) {
            if (property != null) {
                try {
                    Method pm = connection.getClass().getMethod("getProperties", new Class[0]);
                    pm.setAccessible(true);
                    Properties props = (Properties)pm.invoke((Object)connection, new Object[0]);
                    String v = props.getProperty(property);
                    if (v != null) {
                        return parser.apply(v);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defValue;
        }
    }

    private boolean isDual(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).equals(this.sysDualId.getComponents().get(0));
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID relationID) {
        if (this.isDual(relationID)) {
            return this.sysDualId;
        }
        return super.getCanonicalRelationId(relationID);
    }

    @Override
    protected void checkSameRelationID(RelationID extractedId, RelationID givenId, String method) throws MetadataExtractionException {
        if (this.isDual(extractedId) && this.isDual(givenId)) {
            return;
        }
        super.checkSameRelationID(extractedId, givenId, method);
    }

    @Override
    protected ResultSet getColumnsResultSet(RelationID id) throws SQLException {
        if (this.isDual(id)) {
            return super.getColumnsResultSet(id);
        }
        try {
            String query = this.getColumnsSql();
            PreparedStatement stmt = this.connection.prepareStatement(query);
            String schema = this.getRelationSchema(id);
            stmt.setString(1, schema);
            String table = this.getRelationName(id);
            stmt.setString(2, table);
            if (this.includeSynonyms) {
                stmt.setString(3, schema);
                stmt.setString(4, table);
            }
            stmt.closeOnCompletion();
            stmt.setPoolable(false);
            ResultSet rs = stmt.executeQuery();
            if (rs.getFetchSize() < 4048) {
                rs.setFetchSize(4048);
            }
            return rs;
        }
        catch (Throwable e) {
            LOGGER.debug("[DB-METADATA] Reverting to the default implementation: {}", (Object)e.toString());
            return super.getColumnsResultSet(id);
        }
    }

    private String getColumnsSql() {
        ImmutableMap otherColumns = ImmutableMap.of((Object)"COLUMN_NAME", (Object)OracleDBMetadataProvider.sqlColumn("column_name"), (Object)"DATA_TYPE", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlSubstring(OracleDBMetadataProvider.sqlColumn("data_type"), 1, "TIMESTAMP".length()), ImmutableMap.of((Object)"TIMESTAMP", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlSubstring(OracleDBMetadataProvider.sqlColumn("data_type"), "TIMESTAMP".length() + 1, 1), ImmutableMap.of((Object)"(", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlSubstring(OracleDBMetadataProvider.sqlColumn("data_type"), "TIMESTAMP(X) WITH ".length() + 1, "LOCAL".length()), ImmutableMap.of((Object)"LOCAL", (Object)-102, (Object)"TIME", (Object)-101), 93)), OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlSubstring(OracleDBMetadataProvider.sqlColumn("data_type"), "TIMESTAMP WITH ".length() + 1, "LOCAL".length()), ImmutableMap.of((Object)"LOCAL", (Object)-102, (Object)"TIME", (Object)-101), 93)), (Object)"INTERVAL", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlSubstring(OracleDBMetadataProvider.sqlColumn("data_type"), "INTERVAL ".length() + 1, "DAY".length()), ImmutableMap.of((Object)"DAY", (Object)-104, (Object)"YEA", (Object)-103))), OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlColumn("data_type"), this.getSupportedSimpleTypes(), OracleDBMetadataProvider.sqlDecode("(SELECT a.typecode                       FROM ALL_TYPES a                       WHERE a.type_name = t.data_type                           AND ((a.owner IS NULL AND t.data_type_owner IS NULL)                             OR (a.owner = t.data_type_owner)))", ImmutableMap.of((Object)"OBJECT", (Object)2002, (Object)"COLLECTION", (Object)2003), 1111))), (Object)"TYPE_NAME", (Object)OracleDBMetadataProvider.sqlColumn("data_type"), (Object)"COLUMN_SIZE", (Object)OracleDBMetadataProvider.sqlDecodeNull(OracleDBMetadataProvider.sqlColumn("data_precision"), OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlColumn("data_type"), ImmutableMap.of((Object)"NUMBER", (Object)OracleDBMetadataProvider.sqlDecodeNull(OracleDBMetadataProvider.sqlColumn("data_scale"), this.j2ee13Compliant ? "38" : "0", "38")), OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlColumn("data_type"), ImmutableMap.of((Object)"CHAR", (Object)OracleDBMetadataProvider.sqlColumn("char_length"), (Object)"VARCHAR", (Object)OracleDBMetadataProvider.sqlColumn("char_length"), (Object)"VARCHAR2", (Object)OracleDBMetadataProvider.sqlColumn("char_length"), (Object)"NVARCHAR2", (Object)OracleDBMetadataProvider.sqlColumn("char_length"), (Object)"NCHAR", (Object)OracleDBMetadataProvider.sqlColumn("char_length"), (Object)"NUMBER", (Object)"0"), OracleDBMetadataProvider.sqlColumn("data_length"))), OracleDBMetadataProvider.sqlColumn("data_precision")), (Object)"DECIMAL_DIGITS", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlColumn("data_type"), ImmutableMap.of((Object)"NUMBER", (Object)OracleDBMetadataProvider.sqlDecodeNull(OracleDBMetadataProvider.sqlColumn("data_precision"), OracleDBMetadataProvider.sqlDecodeNull(OracleDBMetadataProvider.sqlColumn("data_scale"), this.j2ee13Compliant ? "0" : "-127", OracleDBMetadataProvider.sqlColumn("data_scale")), OracleDBMetadataProvider.sqlColumn("data_scale"))), OracleDBMetadataProvider.sqlColumn("data_scale")), (Object)"NULLABLE", (Object)OracleDBMetadataProvider.sqlDecode(OracleDBMetadataProvider.sqlColumn("nullable"), ImmutableMap.of((Object)"N", (Object)0), 1), (Object)"ORDINAL_POSITION", (Object)OracleDBMetadataProvider.sqlColumn("column_id"));
        String queryHint = this.includeSynonyms && this.versionNumber >= 10200 && this.versionNumber < 11100 ? "/*+ CHOOSE */" : "";
        String allColumnsTable = this.versionNumber >= 12000 ? "all_tab_cols" : "all_tab_columns";
        String userGeneratedFilter = this.versionNumber >= 12000 ? " AND " + OracleDBMetadataProvider.sqlColumn("user_generated") + " = 'YES'" : "";
        return OracleDBMetadataProvider.sqlSelectFromWhere(queryHint, OracleDBMetadataProvider.concat((ImmutableMap<String, String>)ImmutableMap.of((Object)"TABLE_CAT", (Object)"NULL", (Object)"TABLE_SCHEM", (Object)OracleDBMetadataProvider.sqlColumn("owner"), (Object)"TABLE_NAME", (Object)OracleDBMetadataProvider.sqlColumn("table_name")), (ImmutableMap<String, String>)otherColumns), allColumnsTable + " t", OracleDBMetadataProvider.sqlColumn("owner") + " = ? AND " + OracleDBMetadataProvider.sqlColumn("table_name") + " = ?" + userGeneratedFilter) + (String)(this.includeSynonyms ? "\nUNION ALL\n" + OracleDBMetadataProvider.sqlSelectFromWhere(queryHint, OracleDBMetadataProvider.concat((ImmutableMap<String, String>)ImmutableMap.of((Object)"TABLE_CAT", (Object)"NULL", (Object)"TABLE_SCHEM", (Object)"REGEXP_SUBSTR(LTRIM(s.owner, '/'), '[^/]+')", (Object)"TABLE_NAME", (Object)"REGEXP_SUBSTR(LTRIM(s.synonym_name, '/'), '[^/]+')"), (ImmutableMap<String, String>)otherColumns), allColumnsTable + " t,\n(SELECT SYS_CONNECT_BY_PATH(owner, '/') owner, SYS_CONNECT_BY_PATH(synonym_name, '/') synonym_name, table_owner, table_name\nFROM all_synonyms\nWHERE CONNECT_BY_ISLEAF = 1\nAND db_link is NULL\nSTART WITH owner = ? AND synonym_name = ?\nCONNECT BY PRIOR table_name = synonym_name\nAND PRIOR table_owner = owner) s", OracleDBMetadataProvider.sqlColumn("owner") + " = s.table_owner AND " + OracleDBMetadataProvider.sqlColumn("table_name") + " = s.table_name " + userGeneratedFilter) : "") + "\nORDER BY " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME", (Object)"ORDINAL_POSITION"));
    }

    private static ImmutableMap<String, String> concat(ImmutableMap<String, String> m1, ImmutableMap<String, String> m2) {
        return (ImmutableMap)Stream.concat(m1.entrySet().stream(), m2.entrySet().stream()).collect(ImmutableCollectors.toMap());
    }

    private static String sqlSubstring(String expression, int start, int length) {
        return "substr(" + expression + ", " + start + ", " + length + ")";
    }

    private static String sqlColumn(String column) {
        return "t." + column;
    }

    private static String sqlSelectFromWhere(String hint, ImmutableMap<String, String> columns, String from, String where) {
        return "SELECT " + hint + " " + columns.entrySet().stream().map(e -> (String)e.getValue() + " AS " + (String)e.getKey()).collect(Collectors.joining(",\n")) + "\nFROM " + from + "\nWHERE " + where;
    }

    private static String sqlDecodeNull(String expression, Object nullValue, Object otherValue) {
        return "DECODE(" + expression + ", NULL, " + nullValue + ", " + otherValue + ")";
    }

    private static String sqlDecode(String expression, Map<String, ?> cases, Object defaultValue) {
        return "DECODE(" + expression + ", " + cases.entrySet().stream().map(e -> "'" + (String)e.getKey() + "', " + e.getValue()).collect(Collectors.joining(", ")) + ", " + defaultValue + ")";
    }

    private static String sqlDecode(String expression, Map<String, ?> cases) {
        return "DECODE(" + expression + ", " + cases.entrySet().stream().map(e -> "'" + (String)e.getKey() + "', " + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }

    private Map<String, Integer> getSupportedSimpleTypes() {
        return ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("BINARY_DOUBLE", 101), Map.entry("BINARY_FLOAT", 100), Map.entry("BFILE", -13), Map.entry("BLOB", 2004), Map.entry("BOOLEAN", 16), Map.entry("CHAR", 1), Map.entry("CLOB", 2005), Map.entry("COLLECTION", 2003), Map.entry("DATE", this.mapDateToTimestamp ? 93 : 91), Map.entry("FLOAT", 6), Map.entry("JSON", 2016), Map.entry("LONG", -1), Map.entry("LONG RAW", -4), Map.entry("NCHAR", -15), Map.entry("NCLOB", 2011), Map.entry("NUMBER", 2), Map.entry("NVARCHAR", -9), Map.entry("NVARCHAR2", -9), Map.entry("OBJECT", 2002), Map.entry("OPAQUE/XMLTYPE", 2009), Map.entry("RAW", -3), Map.entry("REF", 2006), Map.entry("ROWID", -8), Map.entry("SQLXML", 2009), Map.entry("UROWID", -8), Map.entry("VARCHAR2", 12), Map.entry("VARRAY", 2003), Map.entry("VECTOR", -105), Map.entry("XMLTYPE", 2009)});
    }

    @Override
    protected String makeQueryMinimizeResultSet(String query) {
        return String.format("SELECT * FROM (%s) subQ FETCH NEXT 1 ROWS ONLY", query);
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        if (this.isDual(id)) {
            return ImmutableList.of((Object)this.sysDualId);
        }
        return super.getAllIDs(id);
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return id.getComponents().size() > 1 ? ((QuotedID)id.getComponents().get(1)).getName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isRelationExcluded(RelationID id) {
        String schema = this.getRelationSchema(id);
        String table = this.getRelationName(id);
        if (IGNORED_VIEW_SCHEMAS.contains((Object)schema)) return true;
        if (IGNORED_TABLE_SCHEMAS.contains((Object)schema)) return true;
        if (schema.equals("SYSTEM")) {
            if (IGNORED_SYSTEM_VIEWS.contains((Object)table)) return true;
        }
        if (schema.equals("SYSTEM")) {
            if (IGNORED_SYSTEM_TABLES.contains((Object)table)) return true;
        }
        if (IGNORED_VIEW_PREFIXES.stream().anyMatch(table::startsWith)) return true;
        if (!IGNORED_TABLE_PREFIXES.stream().anyMatch(table::startsWith)) return false;
        return true;
    }

    @Override
    protected ResultSet getRelationIDsResultSet() throws SQLException {
        Statement stmt = this.connection.createStatement();
        stmt.closeOnCompletion();
        return stmt.executeQuery("SELECT NULL AS TABLE_CAT, OWNER as TABLE_SCHEM, table_name as TABLE_NAME FROM all_tables UNION ALL SELECT NULL AS TABLE_CAT, owner as TABLE_SCHEM, view_name as TABLE_NAME FROM all_views");
    }

    @Override
    protected boolean isPrimaryKeyDisabled(RelationID id, String primaryKeyId) {
        return this.isConstraintDisabled(id, primaryKeyId);
    }

    @Override
    protected boolean isUniqueConstraintDisabled(RelationID id, String uniqueConstraintId) {
        return this.isUniqueIndexDisabled(id, uniqueConstraintId);
    }

    @Override
    protected boolean isForeignKeyDisabled(RelationID id, String foreignKeyId) {
        return this.isConstraintDisabled(id, foreignKeyId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConstraintDisabled(RelationID id, String constraintId) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT status\nFROM all_constraints\nWHERE constraint_name = :1\n  AND table_name = :2\n  AND owner = :3");){
            stmt.setString(1, constraintId);
            stmt.setString(2, this.getRelationName(id));
            stmt.setString(3, this.getRelationSchema(id));
            stmt.closeOnCompletion();
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) throw new MinorOntopInternalBugException("Constraint " + constraintId + " in " + id + " not found");
            String status = rs.getString("status");
            boolean bl = "DISABLED".equals(status);
            return bl;
        }
        catch (SQLException e) {
            throw new MinorOntopInternalBugException("Error retrieving constraint " + constraintId + " in " + id + " info: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUniqueIndexDisabled(RelationID id, String indexId) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT status\nFROM all_indexes\nWHERE index_name = :1\n  AND table_name = :2\n  AND owner = :3");){
            stmt.setString(1, indexId);
            stmt.setString(2, this.getRelationName(id));
            stmt.setString(3, this.getRelationSchema(id));
            stmt.closeOnCompletion();
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) throw new MinorOntopInternalBugException("Unique index " + indexId + " in " + id + " not found");
            String status = rs.getString("status");
            boolean bl = !"VALID".equals(status);
            return bl;
        }
        catch (SQLException e) {
            throw new MinorOntopInternalBugException("Error retrieving unique index " + indexId + " in " + id + " info: " + e.getMessage());
        }
    }
}

