/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.LensFKSaturator;
import it.unibz.inf.ontop.dbschema.LensMetadataProvider;
import it.unibz.inf.ontop.dbschema.LensNormalizer;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookupWithDependencies;
import it.unibz.inf.ontop.dbschema.impl.DelegatingMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.LensImpl;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLenses;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class LensMetadataProviderImpl
implements LensMetadataProvider {
    private final MetadataProvider parentMetadataProvider;
    private final CachingMetadataLookupWithDependencies dependencyCacheMetadataLookup;
    private final LensNormalizer lensNormalizer;
    private final LensFKSaturator fkSaturator;
    private final ImmutableMap<RelationID, JsonLens> jsonMap;
    private final CachingMetadataLookup parentCachingMetadataLookup;
    private final Set<RelationID> alreadyProcessedViews = new HashSet<RelationID>();
    private final Map<RelationID, NamedRelationDefinition> cachedLenses = new HashMap<RelationID, NamedRelationDefinition>();
    private @Nullable MetadataLookup mergedMetadataLookupForFK;
    private final boolean ignoreInvalidLensEntries;
    private final CoreSingletons coreSingletons;

    @AssistedInject
    protected LensMetadataProviderImpl(@Assisted MetadataProvider parentMetadataProvider, @Assisted Reader lensesReader, LensNormalizer lensNormalizer, LensFKSaturator fkSaturator, CoreSingletons coreSingletons) throws MetadataExtractionException {
        this.parentMetadataProvider = new DelegatingMetadataProvider(parentMetadataProvider){
            private final Set<RelationID> completeRelations;
            {
                this.completeRelations = new HashSet<RelationID>();
            }

            public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
                boolean notComplete = this.completeRelations.add(relation.getID());
                if (notComplete) {
                    this.provider.insertIntegrityConstraints(relation, metadataLookup);
                }
            }
        };
        this.parentCachingMetadataLookup = new CachingMetadataLookup(parentMetadataProvider);
        this.fkSaturator = fkSaturator;
        try (Reader lensReader = lensesReader;){
            JsonLenses jsonLenses = LensMetadataProviderImpl.loadAndDeserialize(lensReader);
            QuotedIDFactory quotedIdFactory = parentMetadataProvider.getQuotedIDFactory();
            this.jsonMap = (ImmutableMap)jsonLenses.relations.stream().collect(ImmutableCollectors.toMap(t -> JsonMetadata.deserializeRelationID(quotedIdFactory, t.name), t -> t));
        }
        catch (JsonProcessingException e) {
            throw new MetadataExtractionException("Problem with JSON processing.\n" + e);
        }
        catch (IOException e) {
            throw new MetadataExtractionException((Exception)e);
        }
        this.lensNormalizer = lensNormalizer;
        this.dependencyCacheMetadataLookup = new CachingMetadataLookupWithDependencies(this);
        this.ignoreInvalidLensEntries = ((OntopOBDASettings)coreSingletons.getSettings()).ignoreInvalidLensEntries();
        this.coreSingletons = coreSingletons;
    }

    protected static JsonLenses loadAndDeserialize(Reader viewReader) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        return (JsonLenses)objectMapper.readValue(viewReader, JsonLenses.class);
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        return (ImmutableList)Stream.concat(this.jsonMap.keySet().stream(), this.parentMetadataProvider.getRelationIDs().stream()).collect(ImmutableCollectors.toList());
    }

    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        JsonLens jsonLens = (JsonLens)this.jsonMap.get((Object)id);
        if (jsonLens != null) {
            try {
                if (!this.cachedLenses.containsKey(id)) {
                    this.cachedLenses.put(id, (NamedRelationDefinition)jsonLens.createViewDefinition(this.getDBParameters(), this.dependencyCacheMetadataLookup.getCachingMetadataLookupFor(id)));
                }
                return this.cachedLenses.get(id);
            }
            catch (MetadataExtractionException | IllegalArgumentException e) {
                if (!this.ignoreInvalidLensEntries) {
                    throw e;
                }
                this.cachedLenses.put(id, (NamedRelationDefinition)new LensImpl(ImmutableList.of((Object)id), new RelationDefinition.AttributeListBuilder(){

                    public RelationDefinition.AttributeListBuilder addAttribute(QuotedID id, DBTermType termType, String typeName, boolean isNullable) {
                        return this;
                    }

                    public RelationDefinition.AttributeListBuilder addAttribute(QuotedID id, DBTermType termType, boolean isNullable) {
                        return this;
                    }

                    public ImmutableList<Attribute> build(RelationDefinition relation) {
                        return ImmutableList.of();
                    }
                }, this.coreSingletons.getIQFactory().createIQ(this.coreSingletons.getAtomFactory().getDistinctVariableOnlyDataAtom(this.coreSingletons.getAtomFactory().getRDFAnswerPredicate(0), ImmutableList.of()), (IQTree)this.coreSingletons.getIQFactory().createTrueNode()), 1, this.coreSingletons));
                AbstractDBMetadataProvider.LOGGER.warn("Lens {} was ignored due to an issue: {}", (Object)id, (Object)e.getMessage());
                return this.cachedLenses.get(id);
            }
        }
        return this.parentCachingMetadataLookup.getRelation(id);
    }

    public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
        return this.parentCachingMetadataLookup.getBlackBoxView(query);
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup initialMetadataLookupForFK) throws MetadataExtractionException {
        MetadataLookup metadataLookupForFK = this.getMergedMetadataLookupForFK(initialMetadataLookupForFK);
        RelationID relationId = relation.getID();
        JsonLens jsonLens = (JsonLens)this.jsonMap.get((Object)relationId);
        if (jsonLens != null && relation instanceof Lens) {
            boolean notInserted = this.alreadyProcessedViews.add(relationId);
            if (notInserted) {
                ImmutableList<NamedRelationDefinition> baseRelations = this.dependencyCacheMetadataLookup.getBaseRelations(relation.getID());
                for (NamedRelationDefinition baseRelation : baseRelations) {
                    this.insertIntegrityConstraints(baseRelation, metadataLookupForFK);
                }
                try {
                    jsonLens.insertIntegrityConstraints((Lens)relation, baseRelations, metadataLookupForFK, this.getDBParameters());
                }
                catch (MetadataExtractionException e) {
                    if (this.ignoreInvalidLensEntries) {
                        AbstractDBMetadataProvider.LOGGER.warn("Integrity constraints on lens {} were ignored due to an issue: {}", (Object)relationId, (Object)e.getMessage());
                        return;
                    }
                    throw e;
                }
                ArrayDeque<NamedRelationDefinition> lensesForPropagation = new ArrayDeque<NamedRelationDefinition>();
                lensesForPropagation.add(relation);
                while (!lensesForPropagation.isEmpty()) {
                    ImmutableList<NamedRelationDefinition> currentPropagationParents;
                    NamedRelationDefinition currentPropagationLens = (NamedRelationDefinition)lensesForPropagation.poll();
                    JsonLens currentPropagationJsonLens = (JsonLens)this.jsonMap.get((Object)currentPropagationLens.getID());
                    if (currentPropagationJsonLens.propagateUniqueConstraintsUp((Lens)currentPropagationLens, currentPropagationParents = this.dependencyCacheMetadataLookup.getBaseRelations(currentPropagationLens.getID()), this.getQuotedIDFactory())) {
                        lensesForPropagation.addAll(currentPropagationParents.stream().filter(l -> l instanceof Lens).collect(Collectors.toList()));
                    }
                    if (!currentPropagationJsonLens.propagateForeignKeyConstraintsUp((Lens)currentPropagationLens, currentPropagationParents, this.getQuotedIDFactory())) continue;
                    lensesForPropagation.addAll(currentPropagationParents.stream().filter(l -> l instanceof Lens).collect(Collectors.toList()));
                }
            }
        } else {
            this.parentMetadataProvider.insertIntegrityConstraints(relation, metadataLookupForFK);
        }
    }

    private synchronized MetadataLookup getMergedMetadataLookupForFK(MetadataLookup initialMetadataLookupForFK) {
        if (this.mergedMetadataLookupForFK != null) {
            return this.mergedMetadataLookupForFK;
        }
        return new MergingMetadataLookup(initialMetadataLookupForFK, (MetadataLookup)this.dependencyCacheMetadataLookup.extractImmutableMetadataLookup());
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.parentMetadataProvider.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.parentMetadataProvider.getDBParameters();
    }

    public void normalizeAndOptimizeRelations(List<NamedRelationDefinition> relationDefinitions) {
        ImmutableList viewDefinitions = (ImmutableList)relationDefinitions.stream().filter(Lens.class::isInstance).map(Lens.class::cast).sorted(Comparator.comparingInt(Lens::getLevel)).collect(ImmutableCollectors.toList());
        viewDefinitions.forEach(this.lensNormalizer::normalize);
        this.optimizeViews((ImmutableList<Lens>)viewDefinitions);
        viewDefinitions.forEach(Lens::freeze);
    }

    private void optimizeViews(ImmutableList<Lens> viewDefinitions) {
        this.fkSaturator.saturateForeignKeys(viewDefinitions, this.dependencyCacheMetadataLookup.getChildrenMultimap(), this.jsonMap);
    }

    private static class MergingMetadataLookup
    implements MetadataLookup {
        private final MetadataLookup mainLookup;
        private final MetadataLookup secondaryLookup;

        public MergingMetadataLookup(MetadataLookup mainLookup, MetadataLookup secondaryLookup) {
            this.mainLookup = mainLookup;
            this.secondaryLookup = secondaryLookup;
        }

        public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
            try {
                return this.mainLookup.getRelation(id);
            }
            catch (MetadataExtractionException e) {
                return this.secondaryLookup.getRelation(id);
            }
        }

        public RelationDefinition getBlackBoxView(String query) {
            throw new UnsupportedOperationException();
        }

        public QuotedIDFactory getQuotedIDFactory() {
            return this.mainLookup.getQuotedIDFactory();
        }
    }
}

