/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.SerializedMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.json.JsonDatabaseTable;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class JsonSerializedMetadataProvider
implements SerializedMetadataProvider {
    private final DBParameters dbParameters;
    private final ImmutableMap<RelationID, JsonDatabaseTable> relationMap;
    private final ImmutableMap<RelationID, RelationID> otherNames;
    private @Nullable MetadataLookup parentProvider;
    private final @Nullable SerializedMetadataProvider.MetadataLookupSupplier parentProviderSupplier;

    @AssistedInject
    protected JsonSerializedMetadataProvider(@Assisted Reader dbMetadataReader, QuotedIDFactory.Supplier idFactorySupplier, CoreSingletons coreSingletons) throws MetadataExtractionException, IOException {
        this(dbMetadataReader, null, idFactorySupplier, coreSingletons);
    }

    @AssistedInject
    protected JsonSerializedMetadataProvider(@Assisted Reader dbMetadataReader, @Nullable @Assisted SerializedMetadataProvider.MetadataLookupSupplier parentProviderSupplier, QuotedIDFactory.Supplier idFactorySupplier, CoreSingletons coreSingletons) throws MetadataExtractionException, IOException {
        JsonMetadata jsonMetadata = this.loadAndDeserialize(dbMetadataReader, idFactorySupplier);
        QuotedIDFactory idFactory = jsonMetadata.metadata.createQuotedIDFactory();
        this.dbParameters = new BasicDBParametersImpl(jsonMetadata.metadata.driverName, jsonMetadata.metadata.driverVersion, jsonMetadata.metadata.dbmsProductName, jsonMetadata.metadata.dbmsVersion, idFactory, coreSingletons);
        coreSingletons.getDatabaseInfoSupplier().setDatabaseVersion(jsonMetadata.metadata.dbmsVersion);
        this.relationMap = (ImmutableMap)jsonMetadata.relations.stream().collect(ImmutableCollectors.toMap(t -> JsonMetadata.deserializeRelationID(idFactory, t.name), t -> t));
        this.otherNames = (ImmutableMap)jsonMetadata.relations.stream().flatMap(t -> {
            RelationID mainId = JsonMetadata.deserializeRelationID(idFactory, t.name);
            return t.otherNames.stream().map(n -> JsonMetadata.deserializeRelationID(idFactory, n)).filter(n -> !n.equals(mainId)).map(id -> Maps.immutableEntry((Object)id, (Object)mainId));
        }).collect(ImmutableCollectors.toMap());
        this.parentProviderSupplier = parentProviderSupplier;
    }

    protected JsonMetadata loadAndDeserialize(Reader dbMetadataReader, QuotedIDFactory.Supplier idFactorySupplier) throws MetadataExtractionException, IOException {
        try {
            ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(QuotedIDFactory.Supplier.class, (Object)idFactorySupplier));
            return (JsonMetadata)objectMapper.readValue(dbMetadataReader, JsonMetadata.class);
        }
        catch (JsonProcessingException e) {
            throw new MetadataExtractionException("problem with JSON processing.\n" + e, (Exception)((Object)e));
        }
    }

    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        JsonDatabaseTable jsonTable = (JsonDatabaseTable)this.relationMap.get((Object)id);
        if (jsonTable == null) {
            RelationID mainId = (RelationID)this.otherNames.get((Object)id);
            if (mainId == null) {
                Optional<MetadataLookup> optionalParentProvider = this.getParentProvider();
                if (optionalParentProvider.isPresent()) {
                    return optionalParentProvider.get().getRelation(id);
                }
                throw new IllegalArgumentException("The relation " + id.getSQLRendering() + " is unknown to the JsonSerializedMetadataProvider");
            }
            return this.getRelation(mainId);
        }
        return jsonTable.createDatabaseTableDefinition(this.dbParameters);
    }

    public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
        Optional<MetadataLookup> optionalParentProvider = this.getParentProvider();
        if (optionalParentProvider.isPresent()) {
            return optionalParentProvider.get().getBlackBoxView(query);
        }
        throw new UnsupportedOperationException("Has no parent provider. Should not have been called");
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public ImmutableList<RelationID> getRelationIDs() {
        return ImmutableList.copyOf((Collection)this.relationMap.keySet());
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookupForFk) throws MetadataExtractionException {
        JsonDatabaseTable jsonTable = (JsonDatabaseTable)this.relationMap.get((Object)relation.getID());
        if (jsonTable == null) {
            Optional<MetadataProvider> optionalParentProvider = this.getParentProvider().filter(p -> p instanceof MetadataProvider).map(p -> (MetadataProvider)p);
            if (optionalParentProvider.isPresent()) {
                optionalParentProvider.get().insertIntegrityConstraints(relation, metadataLookupForFk);
                return;
            }
            throw new IllegalArgumentException("The relation " + relation.getID().getSQLRendering() + " is unknown to the JsonSerializedMetadataProvider");
        }
        jsonTable.insertIntegrityConstraints(relation, metadataLookupForFk);
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    public void normalizeAndOptimizeRelations(List<NamedRelationDefinition> relationDefinitions) {
    }

    protected synchronized Optional<MetadataLookup> getParentProvider() throws MetadataExtractionException {
        if (this.parentProvider == null && this.parentProviderSupplier != null) {
            this.parentProvider = this.parentProviderSupplier.get();
        }
        return Optional.ofNullable(this.parentProvider);
    }
}

