/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.DremioQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;

public class DremioDBMetadataProvider
extends AbstractDBMetadataProvider {
    private final @Nullable QuotedID defaultSchema;
    private static final int SCHEMA_INDEX = 1;

    @AssistedInject
    DremioDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new DremioQuotedIDFactory(), coreSingletons);
        QuotedID localDefaultSchema = null;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT CURRENT_SCHEMA AS TABLE_SCHEM");){
            rs.next();
            String defaultSchemaName = rs.getString("TABLE_SCHEM");
            RelationID id = this.rawIdFactory.createRelationID(new String[]{defaultSchemaName, "DUMMY"});
            localDefaultSchema = (QuotedID)id.getComponents().get(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.defaultSchema = localDefaultSchema;
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) {
        return this.defaultSchema == null || id.getComponents().size() > 1 ? id : new RelationIDImpl(ImmutableList.of((Object)((QuotedID)id.getComponents().get(0)), (Object)this.defaultSchema));
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        return this.hasDefaultSchema(id) ? ImmutableList.of((Object)id, (Object)id.getTableOnlyID()) : ImmutableList.of((Object)id);
    }

    private boolean hasDefaultSchema(RelationID id) {
        if (this.defaultSchema == null || id.getComponents().size() < 2) {
            return false;
        }
        return ((QuotedID)id.getComponents().get(1)).equals(this.defaultSchema);
    }

    @Override
    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        try {
            return super.getRelation(id);
        }
        catch (RelationNotFoundInMetadataException e) {
            try (Statement st = this.connection.createStatement();){
                st.execute("SELECT * FROM " + id.getSQLRendering() + " WHERE 1 = 0");
            }
            catch (SQLException ex) {
                throw new MetadataExtractionException((Exception)ex);
            }
            return super.getRelation(id);
        }
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.rawIdFactory.createRelationID(new String[]{rs.getString(schemaNameColumn), rs.getString(tableNameColumn)});
    }

    @Override
    protected String getRelationCatalog(RelationID id) {
        return null;
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return ((QuotedID)id.getComponents().get(1)).getName();
    }

    @Override
    protected String getRelationName(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).getName();
    }

    @Override
    protected ResultSet getRelationIDsResultSet() throws SQLException {
        String[] stringArray;
        if (this.getSettings().exposeSystemTables()) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "TABLE";
            stringArray2[1] = "VIEW";
            stringArray2[2] = "MATERIALIZED VIEW";
            stringArray2[3] = "SYSTEM_TABLE";
            stringArray = stringArray2;
            stringArray2[4] = "SYSTEM_VIEW";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "TABLE";
            stringArray3[1] = "VIEW";
            stringArray = stringArray3;
            stringArray3[2] = "MATERIALIZED VIEW";
        }
        return this.metadata.getTables(null, null, null, stringArray);
    }
}

