/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.LensFKSaturator;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.UUID;
import java.util.stream.IntStream;

public class BasicLensFKSaturator
implements LensFKSaturator {
    @Inject
    protected BasicLensFKSaturator() {
    }

    @Override
    public void saturateForeignKeys(ImmutableList<Lens> lenses, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonLens> jsonLensMap) {
        ImmutableMap lensMap = (ImmutableMap)lenses.stream().collect(ImmutableCollectors.toMap(NamedRelationDefinition::getID, d -> d));
        lenses.forEach(v -> this.saturate((Lens)v, childrenMultimap, jsonLensMap, (ImmutableMap<RelationID, Lens>)lensMap));
    }

    private void saturate(Lens view, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonLens> jsonLensMap, ImmutableMap<RelationID, Lens> lensMap) {
        view.getForeignKeys().forEach(fk -> this.deriveFK(view, (ForeignKeyConstraint)fk, childrenMultimap, jsonLensMap, lensMap));
    }

    private void deriveFK(Lens view, ForeignKeyConstraint foreignKey, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonLens> jsonLensMap, ImmutableMap<RelationID, Lens> lensMap) {
        NamedRelationDefinition targetRelation = foreignKey.getReferencedRelation();
        RelationID targetRelationId = targetRelation.getID();
        if (childrenMultimap.containsKey((Object)targetRelationId)) {
            ImmutableList targetAttributes = (ImmutableList)foreignKey.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute).collect(ImmutableCollectors.toList());
            childrenMultimap.get((Object)targetRelationId).forEach(c -> this.deriveFKTarget(view, foreignKey, (RelationID)c, (ImmutableList<Attribute>)targetAttributes, childrenMultimap, jsonLensMap, lensMap));
        }
    }

    private void deriveFKTarget(Lens sourceView, ForeignKeyConstraint foreignKey, RelationID childIdOfTarget, ImmutableList<Attribute> targetAttributes, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonLens> jsonViewMap, ImmutableMap<RelationID, Lens> viewDefinitionMap) {
        if (!jsonViewMap.containsKey((Object)childIdOfTarget) || !viewDefinitionMap.containsKey((Object)childIdOfTarget)) {
            return;
        }
        Lens childRelation = (Lens)viewDefinitionMap.get((Object)childIdOfTarget);
        ((JsonLens)jsonViewMap.get((Object)childIdOfTarget)).getAttributesIncludingParentOnes(childRelation, targetAttributes).forEach(as -> this.addForeignKey(sourceView, foreignKey, childRelation, (ImmutableList<Attribute>)as));
    }

    private void addForeignKey(Lens sourceView, ForeignKeyConstraint initialFK, Lens targetRelation, ImmutableList<Attribute> targetAttributes) {
        if (sourceView.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(targetRelation)).filter(fk -> fk.getComponents().size() == targetAttributes.size()).anyMatch(fk -> ((ImmutableList)fk.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute).collect(ImmutableCollectors.toList())).equals((Object)targetAttributes))) {
            return;
        }
        ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)UUID.randomUUID().toString(), (NamedRelationDefinition)sourceView, (NamedRelationDefinition)targetRelation);
        ImmutableList initialComponents = initialFK.getComponents();
        IntStream.range(0, targetAttributes.size()).boxed().forEach(i -> builder.add(((ForeignKeyConstraint.Component)initialComponents.get(i.intValue())).getAttribute().getIndex(), ((Attribute)targetAttributes.get(i.intValue())).getIndex()));
        builder.build();
    }
}

