/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.iterators;

import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.ExternalStoreStatus;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.json.simple.JSONObject;

public class StatusIterator
extends StatementIterator {
    private final Iterator<Map.Entry<Long, ExternalStore>> requestedStoresIterator;
    private final Entities entities;

    public StatusIterator(Map<Long, ExternalStore> requestedStores, Entities entities) {
        this.requestedStoresIterator = requestedStores.entrySet().iterator();
        this.entities = entities;
    }

    public boolean next() {
        if (this.requestedStoresIterator.hasNext()) {
            Map.Entry<Long, ExternalStore> requestedStore = this.requestedStoresIterator.next();
            this.subject = requestedStore.getKey();
            ExternalStoreStatus status = requestedStore.getValue().getStatus();
            JSONObject jsonStatus = new JSONObject();
            jsonStatus.put((Object)"status", (Object)status.status.name());
            if (status.status == ExternalStoreStatus.Status.BUILDING) {
                jsonStatus.put((Object)"estimatedEntities", (Object)status.estimatedEntities);
                jsonStatus.put((Object)"processedEntities", (Object)status.processedEntities);
                jsonStatus.put((Object)"indexedEntities", (Object)status.indexedEntities);
                long timeDelta = System.currentTimeMillis() - status.buildBeginTime;
                if (timeDelta > 0L) {
                    long entitiesPerSecond = 1000L * status.processedEntities / timeDelta;
                    jsonStatus.put((Object)"entitiesPerSecond", (Object)entitiesPerSecond);
                    if (entitiesPerSecond > 0L) {
                        jsonStatus.put((Object)"etaSeconds", (Object)((status.estimatedEntities - status.processedEntities) / entitiesPerSecond));
                    } else {
                        jsonStatus.put((Object)"etaSeconds", null);
                    }
                } else {
                    jsonStatus.put((Object)"entitiesPerSecond", (Object)0);
                    jsonStatus.put((Object)"etaSeconds", null);
                }
                jsonStatus.put((Object)"repair", (Object)status.repair);
            }
            this.object = this.entities.put((Value)SimpleValueFactory.getInstance().createLiteral(jsonStatus.toJSONString()), Entities.Scope.REQUEST);
            return true;
        }
        return false;
    }

    public void close() {
    }
}

