/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.version;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.ontotext.graphdb.version.VersionService;
import com.ontotext.license.License;
import com.ontotext.license.LicenseRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class VersionController
extends AbstractController {
    public static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String PRODUCT_TYPE = "productType";
    private static final String PRODUCT_VERSION = "productVersion";
    private VersionService service;

    public VersionController() {
        this.setSupportedMethods(new String[]{"GET"});
        this.service = new VersionService();
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)response.getOutputStream());
        generator.writeStartObject();
        generator.writeStringField(PRODUCT_TYPE, this.getNormalisedProductType());
        generator.writeStringField(PRODUCT_VERSION, this.service.getVersion());
        this.service.forEachComponents((arg_0, arg_1) -> ((JsonGenerator)generator).writeStringField(arg_0, arg_1));
        generator.writeEndObject();
        generator.flush();
        return null;
    }

    private String getNormalisedProductType() {
        License.Product productType = LicenseRegistry.getInstance().getProduct();
        if (productType == null) {
            return "unknown";
        }
        return productType.toHumanReadable();
    }

    void setService(VersionService service) {
        this.service = service;
    }
}

