/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame.sos;

import com.ontotext.graphdb.sesame.sos.SOSSplitQueryExtractor;
import com.ontotext.trree.QueryTimeoutErrorException;
import com.ontotext.trree.RepositoryMonitorTrackRecord;
import com.ontotext.trree.RepositoryMonitorTrackRecordHelper;
import com.ontotext.trree.RepositoryMonitorTrackRecordImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.explanation.Explanation;

public class SOSSplitQuery
implements TupleQuery {
    public static final String PLATFORM_SUBSELECT_QUERY_HEADER = "X-GraphDB-SplitQuery";
    public static final String PLATFORM_SUBSELECT_LIMIT_HEADER = "X-GraphDB-SplitQueryLimit";
    public static final String CLUSTER_THREADS_CONFIG_PROPERTY = "graphdb.sos.cluster.numOfThreads";
    public static final String QUERY_INTERRUPTED_BY_THE_USER = "Query interrupted by the user";
    private Query rootQuery;
    private int limit;
    private Handler rootHandler = null;
    boolean complete = false;
    private List<String> namesList = new ArrayList<String>();
    private BlockingQueue<BindingSet> queue = new LinkedBlockingQueue<BindingSet>(1000);
    private Function<String, TupleQuery> op;
    private final AtomicBoolean aborted = new AtomicBoolean();
    private RepositoryMonitorTrackRecordHelper trackRecordHelper;
    private ExecutorService exSrvc;
    private RepositoryMonitorTrackRecordImpl trackRecord;

    public SOSSplitQuery(Query rootQuery, int limit) {
        this.rootQuery = rootQuery;
        this.limit = limit;
    }

    public static SOSSplitQuery parse(String queryStr, int limit) {
        SOSSplitQueryExtractor extractor = new SOSSplitQueryExtractor(queryStr, null, null);
        Query root = extractor.process().build();
        return new SOSSplitQuery(root, limit);
    }

    public Query getRootQuery() {
        return this.rootQuery;
    }

    public void setParserOp(Function<String, TupleQuery> op) {
        this.op = op;
    }

    public Function<String, TupleQuery> getOp() {
        return this.op;
    }

    public void report(BindingSet bindings) {
        while (true) {
            try {
                this.queue.put(bindings);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    public void setAborted(boolean aborted) {
        this.aborted.set(aborted);
    }

    public Handler build(int numOfThreads) {
        this.exSrvc = Executors.newFixedThreadPool(numOfThreads);
        this.rootHandler = new Handler(this.getRootQuery()){

            @Override
            public void endQueryResult() throws TupleQueryResultHandlerException {
                try {
                    while (!this.solutionQueue.isEmpty()) {
                        if (SOSSplitQuery.this.aborted.get()) {
                            throw new QueryInterruptedException(SOSSplitQuery.QUERY_INTERRUPTED_BY_THE_USER);
                        }
                        BindingSet bs = (BindingSet)this.solutionQueue.poll();
                        SOSSplitQuery.this.exSrvc.submit(() -> this.callSubSteps(bs));
                    }
                }
                finally {
                    SOSSplitQuery.this.exSrvc.shutdown();
                    try {
                        SOSSplitQuery.this.exSrvc.awaitTermination(1L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ex) {
                        throw new QueryTimeoutErrorException();
                    }
                }
            }
        };
        return this.rootHandler;
    }

    public TupleQueryResult evaluate() {
        final Thread execThread = new Thread(){

            @Override
            public void run() {
                this.setName("split-query-" + System.identityHashCode(SOSSplitQuery.this));
                SOSSplitQuery.this.rootHandler.query.evaluate((TupleQueryResultHandler)SOSSplitQuery.this.rootHandler);
                SOSSplitQuery.this.trackRecordHelper.closeTrackRecord(SOSSplitQuery.this.trackRecord);
                SOSSplitQuery.this.complete = true;
            }
        };
        execThread.start();
        return new TupleQueryResult(){
            int processed = 0;

            public void remove() throws QueryEvaluationException {
            }

            public BindingSet next() throws QueryEvaluationException {
                if (SOSSplitQuery.this.aborted.get()) {
                    throw new QueryInterruptedException(SOSSplitQuery.QUERY_INTERRUPTED_BY_THE_USER);
                }
                BindingSet bs = (BindingSet)SOSSplitQuery.this.queue.poll();
                this.processed += bs.size();
                return bs;
            }

            public boolean hasNext() throws QueryEvaluationException {
                if (this.processed > SOSSplitQuery.this.limit) {
                    execThread.interrupt();
                    return false;
                }
                while (!SOSSplitQuery.this.complete && SOSSplitQuery.this.queue.isEmpty() && execThread.isAlive()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
                return !SOSSplitQuery.this.queue.isEmpty();
            }

            public void close() throws QueryEvaluationException {
                execThread.interrupt();
            }

            public List<String> getBindingNames() throws QueryEvaluationException {
                if (SOSSplitQuery.this.namesList.isEmpty()) {
                    LinkedHashSet bindings = new LinkedHashSet();
                    this.addBindingsFromQuery(SOSSplitQuery.this.rootQuery, bindings);
                    SOSSplitQuery.this.namesList.addAll(bindings);
                }
                return SOSSplitQuery.this.namesList;
            }

            private void addBindingsFromQuery(Query query, LinkedHashSet bindings) {
                bindings.addAll(query.getBindings());
            }
        };
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.rootHandler.setMaxExecutionTime(maxQueryTime);
    }

    public int getMaxQueryTime() {
        return this.rootHandler.query.getMaxQueryTime();
    }

    public Explanation explain(Explanation.Level level) {
        return this.rootHandler.query.explain(level);
    }

    public void setBinding(String name, Value value) {
        this.rootHandler.query.setBinding(name, value);
    }

    public void removeBinding(String name) {
        this.rootHandler.query.removeBinding(name);
    }

    public void clearBindings() {
        this.rootHandler.query.clearBindings();
    }

    public BindingSet getBindings() {
        return this.rootHandler.query.getBindings();
    }

    public void setDataset(Dataset dataset) {
        this.rootHandler.setDataset(dataset);
    }

    public Dataset getDataset() {
        return this.rootHandler.query.getDataset();
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.rootHandler.setIncludeInferred(includeInferred);
    }

    public boolean getIncludeInferred() {
        return this.rootHandler.query.getIncludeInferred();
    }

    public void setMaxExecutionTime(int maxExecutionTimeSeconds) {
        this.rootHandler.setMaxExecutionTime(maxExecutionTimeSeconds);
    }

    public int getMaxExecutionTime() {
        return this.rootHandler.query.getMaxExecutionTime();
    }

    public void setRepositoryMonitorTrackRecordHelper(RepositoryMonitorTrackRecordHelper trackRecordHelper) {
        this.trackRecordHelper = trackRecordHelper;
    }

    public void setTrackRecord(RepositoryMonitorTrackRecordImpl trackRecord) {
        this.trackRecord = trackRecord;
    }

    class Handler
    implements TupleQueryResultHandler {
        TupleQuery query;
        Query node;
        List<Handler> steps = new ArrayList<Handler>();
        Map<Handler, Map<String, Set<String>>> processed = new HashMap<Handler, Map<String, Set<String>>>();
        Queue<BindingSet> solutionQueue = new LinkedList<BindingSet>();

        Handler(Query node) {
            this.node = node;
            for (Query sub : node.subQueries) {
                this.addStep(new Handler(sub));
            }
            this.query = SOSSplitQuery.this.getOp().apply(node.sparql);
        }

        void setDataset(Dataset dataset) {
            if (dataset != null) {
                this.query.setDataset(dataset);
                this.steps.forEach(handler -> handler.setDataset(dataset));
            }
        }

        void setIncludeInferred(boolean includeInferred) {
            this.query.setIncludeInferred(includeInferred);
            this.steps.forEach(handler -> handler.setIncludeInferred(includeInferred));
        }

        void setMaxExecutionTime(int maxExecutionTimeSeconds) {
            if (maxExecutionTimeSeconds > 0) {
                this.query.setMaxExecutionTime(maxExecutionTimeSeconds);
                this.steps.forEach(handler -> handler.setMaxExecutionTime(maxExecutionTimeSeconds));
            }
        }

        Handler addStep(Handler handler) {
            this.steps.add(handler);
            return this;
        }

        public void handleBoolean(boolean value) throws QueryResultHandlerException {
        }

        public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        }

        public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        }

        public void endQueryResult() throws TupleQueryResultHandlerException {
            while (!this.solutionQueue.isEmpty()) {
                if (SOSSplitQuery.this.aborted.get()) {
                    throw new QueryInterruptedException(SOSSplitQuery.QUERY_INTERRUPTED_BY_THE_USER);
                }
                this.callSubSteps(this.solutionQueue.poll());
            }
        }

        public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
            if (Thread.interrupted()) {
                return;
            }
            if (SOSSplitQuery.this.aborted.get()) {
                throw new QueryInterruptedException(SOSSplitQuery.QUERY_INTERRUPTED_BY_THE_USER);
            }
            SOSSplitQuery.this.report(bindingSet);
            this.solutionQueue.add(bindingSet);
        }

        protected void callSubSteps(BindingSet bindingSet) {
            if (SOSSplitQuery.this.trackRecordHelper != null) {
                RepositoryMonitorTrackRecordImpl tr = SOSSplitQuery.this.trackRecordHelper.getTrackRecord();
                tr.setType(RepositoryMonitorTrackRecord.Type.GRAPHQL);
                SOSSplitQuery.this.trackRecordHelper.trackRecordSet(tr);
            }
            for (Handler next : this.steps) {
                if (SOSSplitQuery.this.aborted.get()) {
                    throw new QueryInterruptedException(SOSSplitQuery.QUERY_INTERRUPTED_BY_THE_USER);
                }
                String varName = next.node.iterateOver;
                Binding b = bindingSet.getBinding(varName);
                if (b == null || b.getValue() == null || !this.processed.computeIfAbsent(next, k -> new HashMap()).computeIfAbsent(b.getName(), k -> new HashSet()).add(b.getValue().stringValue())) continue;
                next.evaluate(b.getName(), b.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evaluate(String bn, Value bv) {
            Handler handler = this;
            synchronized (handler) {
                this.query.setBinding(bn, bv);
                this.query.evaluate((TupleQueryResultHandler)this);
            }
        }
    }

    public static class Query {
        String sparql;
        String iterateOver;
        List<Query> subQueries;
        Set<String> bindings;

        public Query(String sparql, String iterateOver) {
            this.sparql = sparql;
            this.iterateOver = iterateOver;
            this.subQueries = new LinkedList<Query>();
        }

        public String getSparql() {
            return this.sparql;
        }

        public void setSparql(String sparql) {
            this.sparql = sparql;
        }

        public void addSubStep(Query subStrep) {
            this.subQueries.add(subStrep);
        }

        public Set<String> getBindings() {
            return this.bindings;
        }

        public void setBindings(Set<String> bindings) {
            this.bindings = bindings;
        }

        public boolean hasSubSteps() {
            return !this.subQueries.isEmpty();
        }

        public static class Builder {
            Supplier<String> querySupplier;
            String iterateOver;
            Collection<Builder> subSteps = new LinkedList<Builder>();
            Set<String> bindings = new LinkedHashSet<String>();

            Query build() {
                Query query = new Query(this.querySupplier.get(), this.iterateOver);
                query.setBindings(this.bindings);
                this.subSteps.stream().map(Builder::build).forEach(query::addSubStep);
                return query;
            }

            Builder querySupplier(Supplier<String> querySupplier) {
                this.querySupplier = querySupplier;
                return this;
            }

            Builder iterateOver(String iterateOver) {
                this.iterateOver = iterateOver;
                return this;
            }

            Builder bindings(Set<String> bindings) {
                this.bindings.addAll(bindings);
                return this;
            }

            Builder addSubStep() {
                Builder builder = new Builder();
                this.subSteps.add(builder);
                return builder;
            }
        }
    }
}

