/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.ontotext.graphdb.sesame.CatchHandler;
import com.ontotext.graphdb.sesame.QueryResultViewBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.catalina.connector.ClientAbortException;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class TupleQueryResultView
extends QueryResultViewBase<TupleQueryResultWriterFactory, TupleQueryResultFormat> {
    private static final String DEFAULT_JSONP_CALLBACK_PARAMETER = "callback";
    private static final Pattern JSONP_VALIDATOR = Pattern.compile("^[A-Za-z]\\w+$");
    private static final TupleQueryResultView INSTANCE = new TupleQueryResultView();

    public static TupleQueryResultView getInstance() {
        return INSTANCE;
    }

    private TupleQueryResultView() {
    }

    @Override
    protected TupleQueryResultFormat getResultFormat(TupleQueryResultWriterFactory factory) {
        return factory.getTupleQueryResultFormat();
    }

    @Override
    protected void renderQueryResult(Map model, HttpServletRequest request, HttpServletResponse response, TupleQueryResultWriterFactory qrWriterFactory, TupleQueryResultFormat qrFormat, OutputStream out) throws IOException, ClientHTTPException {
        String parameter;
        TupleQueryResultWriter qrWriter = qrWriterFactory.getWriter(out);
        TupleQueryResult tupleQueryResult = (TupleQueryResult)model.get("queryResult");
        if (qrWriter.getSupportedSettings().contains(BasicQueryWriterSettings.JSONP_CALLBACK) && (parameter = request.getParameter(DEFAULT_JSONP_CALLBACK_PARAMETER)) != null) {
            if ((parameter = parameter.trim()).isEmpty()) {
                parameter = (String)BasicQueryWriterSettings.JSONP_CALLBACK.getDefaultValue();
            }
            if (!JSONP_VALIDATOR.matcher(parameter).matches()) {
                throw new IOException("Callback function name was invalid");
            }
            qrWriter.getWriterConfig().set((RioSetting)BasicQueryWriterSettings.JSONP_CALLBACK, (Object)parameter);
        }
        qrWriter.getWriterConfig().set((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR, (Object)(!qrFormat.supportsRDFStar() ? 1 : 0));
        try {
            CatchHandler.processWithBuffer(tupleQueryResult, (QueryResultHandler)qrWriter, response, CatchHandler.parseCatchParam(request));
        }
        catch (TupleQueryResultHandlerException e) {
            if (e.getCause() instanceof JsonGenerationException || e.getCause() instanceof ClientAbortException) {
                return;
            }
            throw e;
        }
    }
}

