/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.UUID;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class TransactionalAbstractController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected RepositoryConnection getConnection(HttpServletRequest request) throws ClientHTTPException {
        String transactionId = request.getHeader("X-GraphDB-Transaction-Id");
        if (transactionId != null) {
            return this.uncloseableConnection(this.getConnectionFromTransactionId(transactionId));
        }
        return RepositoryInterceptor.getRepositoryConnection((HttpServletRequest)request);
    }

    private RepositoryConnection uncloseableConnection(RepositoryConnection connection) {
        return new RepositoryConnectionWrapper(this, connection.getRepository(), connection){

            public void close() throws RepositoryException {
            }

            public void begin(TransactionSetting ... settings) {
                this.throwTransactionalException();
            }

            public void begin(IsolationLevel level) throws RepositoryException {
                this.throwTransactionalException();
            }

            public void begin() throws RepositoryException {
                this.throwTransactionalException();
            }

            public void rollback() throws RepositoryException {
                this.throwTransactionalException();
            }

            public void commit() throws RepositoryException {
                this.throwTransactionalException();
            }

            private void throwTransactionalException() {
                throw new IllegalStateException("Shared transactional connection should not be used to perform any explicit begin/commit/rollback operations");
            }
        };
    }

    private RepositoryConnection getConnectionFromTransactionId(String transactionId) {
        Transaction transaction = ActiveTransactionRegistry.INSTANCE.getTransaction(UUID.fromString(transactionId));
        try {
            Field txnConnectionField = transaction.getClass().getDeclaredField("txnConnection");
            txnConnectionField.setAccessible(true);
            RepositoryConnection connection = (RepositoryConnection)txnConnectionField.get(transaction);
            this.logger.info("Using GraphDB extension for transactional namespaces");
            return connection;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RepositoryException("Could not obtain transaction and work around RDF4J issue #5342", (Throwable)e);
        }
    }
}

