/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.ProxiedToRemote;
import com.ontotext.graphdb.sesame.cluster.ClusterQueryResultHandler;
import com.ontotext.graphdb.sesame.handler.GraphDBQueryResultHandler;
import com.ontotext.graphdb.sesame.handler.GraphDBRepositoryRequestHandler;
import com.ontotext.graphdb.sesame.handler.GraphDBRepositoryResolver;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import org.eclipse.rdf4j.http.server.repository.AbstractRepositoryController;
import org.eclipse.rdf4j.http.server.repository.handler.QueryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.handler.RepositoryRequestHandler;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.springframework.context.ApplicationContextException;

public class GraphDBRepositoryController
extends AbstractRepositoryController
implements ProxiedToRemote {
    private static final boolean IS_BALANCER_ENABLED = Config.getPropertyAsBoolean((String)"graphdb.enable.query.load-balance", (boolean)true);
    private final SemanticDataManagement dataManagement;
    private final RepositoryRequestHandler repositoryRequestHandler;
    private QueryRequestHandler queryRequestHandler;

    public GraphDBRepositoryController(SemanticDataManagement dataManagement) throws ApplicationContextException {
        this.dataManagement = dataManagement;
        this.repositoryRequestHandler = new GraphDBRepositoryRequestHandler(dataManagement);
    }

    protected QueryRequestHandler getQueryRequestHandler() {
        RepositoryManager manager = this.dataManagement.getCurrentLocationOrThrow().sesameManager();
        if (manager instanceof ClusterRepositoryManager && IS_BALANCER_ENABLED) {
            ClusterRepositoryManager clusterManager = (ClusterRepositoryManager)manager;
            if (!(this.queryRequestHandler instanceof ClusterQueryResultHandler) && clusterManager.getReplicationCluster().isLeader()) {
                this.queryRequestHandler = new ClusterQueryResultHandler(new GraphDBRepositoryResolver(this.dataManagement), clusterManager.getLoadBalancer());
            } else if (this.queryRequestHandler instanceof ClusterQueryResultHandler && clusterManager.getReplicationCluster().isLeader() && clusterManager.getLoadBalancer() != ((ClusterQueryResultHandler)this.queryRequestHandler).getLoadBalancer()) {
                ((ClusterQueryResultHandler)this.queryRequestHandler).setLoadBalancer(clusterManager.getLoadBalancer());
            }
            if ((this.queryRequestHandler instanceof ClusterQueryResultHandler || this.queryRequestHandler == null) && !clusterManager.getReplicationCluster().isLeader()) {
                this.queryRequestHandler = new GraphDBQueryResultHandler(new GraphDBRepositoryResolver(this.dataManagement));
            }
        } else if (this.queryRequestHandler instanceof ClusterQueryResultHandler || this.queryRequestHandler == null) {
            this.queryRequestHandler = new GraphDBQueryResultHandler(new GraphDBRepositoryResolver(this.dataManagement));
        }
        return this.queryRequestHandler;
    }

    protected RepositoryRequestHandler getRepositoryRequestHandler() {
        return this.repositoryRequestHandler;
    }

    @VisibleForTesting
    static String getVersionOfCopy() {
        return "5.2.2-jakarta";
    }
}

