/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.graphdb.sesame.ExportStatementsView;
import com.ontotext.raft.GraphDBLoadBalancer;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class GraphController
extends org.eclipse.rdf4j.http.server.repository.graph.GraphController {
    private SemanticDataManagement dataManagement;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod = request.getMethod();
        Repository repository = RepositoryInterceptor.getRepository((HttpServletRequest)request);
        if (repository == null) {
            String repoId = RepositoryInterceptor.getRepositoryID((HttpServletRequest)request);
            Object exceptionMsg = StringUtils.isEmpty((CharSequence)repoId) ? "Unknown repository" : "Unknown repository: " + repoId;
            throw new ClientHTTPException(404, (String)exceptionMsg);
        }
        if ("GET".equals(reqMethod)) {
            return this.getExportStatementsResult(repository, request, response);
        }
        if ("HEAD".equals(reqMethod)) {
            return this.getExportStatementsResult(repository, request, response);
        }
        return super.handleRequestInternal(request, response);
    }

    private ModelAndView getExportStatementsResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters((HttpServletRequest)request);
        ValueFactory vf = repository.getValueFactory();
        IRI graph = this.getGraphName(request, vf);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)ProtocolUtil.getAcceptableService((HttpServletRequest)request, (HttpServletResponse)response, (FileFormatServiceRegistry)RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("contexts", new Resource[]{graph});
        model.put("factory", rdfWriterFactory);
        model.put("useInferencing", true);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        model.put("loadBalancer", this.getLoadBalancer());
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private IRI getGraphName(HttpServletRequest request, ValueFactory vf) throws ClientHTTPException {
        String requestURL = request.getRequestURL().toString();
        boolean isServiceRequest = requestURL.endsWith("/service");
        String queryString = request.getQueryString();
        if (isServiceRequest) {
            if (!"default".equalsIgnoreCase(queryString)) {
                IRI graph = ProtocolUtil.parseGraphParam((HttpServletRequest)request, (ValueFactory)vf);
                if (graph == null) {
                    throw new ClientHTTPException(400, "Named or default graph expected for indirect reference request.");
                }
                return graph;
            }
            return null;
        }
        if (queryString != null) {
            throw new ClientHTTPException(400, "No parameters expected for direct reference request.");
        }
        return vf.createIRI(requestURL);
    }

    private GraphDBLoadBalancer getLoadBalancer() {
        RepositoryManager manager = this.dataManagement.getCurrentLocationOrThrow().sesameManager();
        if (manager instanceof ClusterRepositoryManager && ExportStatementsView.enableBalancer) {
            ClusterRepositoryManager clusterManager = (ClusterRepositoryManager)manager;
            return clusterManager.getLoadBalancer();
        }
        return null;
    }

    public void setDataManagement(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }
}

