/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.sesame;

import com.google.protobuf.ByteString;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.replicationcluster.LocalConsistency;
import com.ontotext.graphdb.sesame.cluster.ClusterResultUtil;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.license.LicenseValidationException;
import com.ontotext.raft.GraphDBLoadBalancer;
import com.ontotext.raft.evaluate.ClosableClusterQueryIterator;
import com.ontotext.rio.jsonld.InvalidLinkException;
import com.ontotext.rio.jsonld.JSONLD11AbstractRDFWriter;
import com.ontotext.rio.jsonld.JsonLDUtils;
import com.ontotext.rio.jsonld.NoWhitelistPatternsException;
import io.grpc.StatusRuntimeException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.springframework.web.servlet.View;

public class ExportStatementsView
implements View {
    public static final String SUBJECT_KEY = "subject";
    public static final String PREDICATE_KEY = "predicate";
    public static final String OBJECT_KEY = "object";
    public static final String CONTEXTS_KEY = "contexts";
    public static final String USE_INFERENCING_KEY = "useInferencing";
    public static final String FACTORY_KEY = "factory";
    public static final String HEADERS_ONLY = "headersOnly";
    public static final String LOAD_BALANCER = "loadBalancer";
    public static final boolean enableBalancer = Config.getPropertyAsBoolean((String)"graphdb.enable.query.load-balance", (boolean)true);
    private static final ExportStatementsView INSTANCE = new ExportStatementsView();

    public static ExportStatementsView getInstance() {
        return INSTANCE;
    }

    private ExportStatementsView() {
    }

    public String getContentType() {
        return null;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block34: {
            Resource subj = (Resource)model.get(SUBJECT_KEY);
            IRI pred = (IRI)model.get(PREDICATE_KEY);
            Value obj = (Value)model.get(OBJECT_KEY);
            Resource[] contexts = (Resource[])model.get(CONTEXTS_KEY);
            boolean useInferencing = (Boolean)model.get(USE_INFERENCING_KEY);
            if (subj != null || pred != null || obj != null || contexts.length != 0) {
                try {
                    LicenseRegistry.getInstance().validateLicense();
                }
                catch (LicenseValidationException e) {
                    throw new SailException((Throwable)e);
                }
            }
            boolean headersOnly = (Boolean)model.get(HEADERS_ONLY);
            RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get(FACTORY_KEY);
            RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
            JsonLDUtils.JsonLDProfile jsonLDProfile = null;
            if (rdfFormat == RDFFormat.JSONLD || rdfFormat == RDFFormat.NDJSONLD) {
                try {
                    jsonLDProfile = JsonLDUtils.parseProfile((String)request.getHeader("Accept"), (String)request.getHeader("Link"));
                }
                catch (InvalidLinkException | NoWhitelistPatternsException e) {
                    response.sendError(400, "Invalid link or no whitelist patterns configured: " + e.getMessage());
                    return;
                }
            }
            try (ServletOutputStream out = response.getOutputStream();){
                RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
                response.setStatus(200);
                Object mimeType = rdfFormat.getDefaultMIMEType();
                if (rdfFormat.hasCharset()) {
                    Charset charset = rdfFormat.getCharset();
                    mimeType = (String)mimeType + "; charset=" + charset.name();
                }
                response.setContentType((String)mimeType);
                Object filename = "statements";
                if (rdfFormat.getDefaultFileExtension() != null) {
                    filename = (String)filename + "." + rdfFormat.getDefaultFileExtension();
                }
                response.setHeader("Content-Disposition", "attachment; filename=" + (String)filename);
                if (headersOnly) break block34;
                GraphDBLoadBalancer graphDBLoadBalancer = (GraphDBLoadBalancer)model.get(LOAD_BALANCER);
                if (graphDBLoadBalancer != null) {
                    try (ClosableClusterQueryIterator statements = (ClosableClusterQueryIterator)graphDBLoadBalancer.exportStatements(subj, pred, obj, useInferencing, LocalConsistency.fromHeaderValue((String)request.getHeader("X-GraphDB-Local-Consistency")), RepositoryInterceptor.getRepositoryID((HttpServletRequest)request), contexts, (String)mimeType, request);){
                        if (statements != null) {
                            while (statements.hasNext()) {
                                Data data = (Data)statements.next();
                                if (!data.getError().isEmpty()) {
                                    throw new QueryEvaluationException(data.getError());
                                }
                                ByteString dataset = data.getData();
                                out.write(dataset.toByteArray());
                            }
                        } else {
                            this.exportStatements(request, rdfWriter, jsonLDProfile, subj, pred, obj, useInferencing, contexts);
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        StatusRuntimeException status = null;
                        if (e instanceof StatusRuntimeException) {
                            StatusRuntimeException se;
                            status = se = (StatusRuntimeException)e;
                        } else {
                            Throwable throwable = e.getCause();
                            if (throwable instanceof StatusRuntimeException) {
                                StatusRuntimeException se;
                                status = se = (StatusRuntimeException)throwable;
                            }
                        }
                        if (status != null) {
                            ClusterResultUtil.StatusHandlingResult mappedException = ClusterResultUtil.mapGrpcExceptionToHttpResponseDetails(status, false);
                            throw new ServerHTTPException(mappedException.getHttpStatus(), "Serialization error: " + mappedException.getErrorMessage(), (Throwable)e);
                        }
                        throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
                    }
                }
                this.exportStatements(request, rdfWriter, jsonLDProfile, subj, pred, obj, useInferencing, contexts);
            }
            catch (RDFHandlerException e) {
                throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void exportStatements(HttpServletRequest request, RDFWriter rdfWriter, JsonLDUtils.JsonLDProfile jsonLDProfile, Resource subj, IRI pred, Value obj, boolean useInferencing, Resource[] contexts) throws ClientHTTPException {
        try (RepositoryConnection conn = RepositoryInterceptor.getRepositoryConnection((HttpServletRequest)request);){
            if (rdfWriter instanceof JSONLD11AbstractRDFWriter) {
                ((JSONLD11AbstractRDFWriter)rdfWriter).setProfile(jsonLDProfile);
                ((JSONLD11AbstractRDFWriter)rdfWriter).setRepoConnection(conn);
            }
            conn.exportStatements(subj, pred, obj, useInferencing, (RDFHandler)rdfWriter, contexts);
        }
    }
}

