/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sesame.report;

import com.ontotext.graphdb.GraphDBStateReport;
import com.ontotext.graphdb.http.ProxiedToRemote;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

@Tag(name="Report Management", description="Handles operations related to system reports")
@RestController
@RequestMapping(value={"/rest/report"})
public class ReportStateController
extends AbstractController
implements ProxiedToRemote {
    private static final String STATUS = "status";
    private GraphDBStateReport graphDBStateReport;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ");

    public ReportStateController() {
        this.graphDBStateReport = GraphDBStateReport.newInstance();
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if ("GET".equals(httpServletRequest.getMethod())) {
            if (httpServletRequest.getRequestURI().endsWith(STATUS)) {
                this.processGetStatusRequest(httpServletResponse);
            } else {
                this.processDownloadReportRequest(httpServletResponse);
            }
        } else if ("POST".equals(httpServletRequest.getMethod())) {
            this.processPostRequest(httpServletRequest, httpServletResponse);
        }
        httpServletResponse.flushBuffer();
        return null;
    }

    @Operation(summary="Get Report Status", description="Fetches the current report state and last modified timestamp.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    private void processGetStatusRequest(HttpServletResponse httpServletResponse) throws Exception {
        String reportState = this.graphDBStateReport.getReportState().toString();
        if (reportState.equals(GraphDBStateReport.ReportState.ERROR.toString())) {
            httpServletResponse.getWriter().write(String.format("%s|%d|%s", reportState, this.getLastModified(), this.graphDBStateReport.getErrorMessage()));
        } else {
            httpServletResponse.getWriter().write(String.format("%s|%d", reportState, this.getLastModified()));
        }
    }

    @Operation(summary="Download Latest Report", description="Downloads the latest generated report.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @RequestMapping(method={RequestMethod.GET})
    private void processDownloadReportRequest(HttpServletResponse httpServletResponse) throws Exception {
        if (this.graphDBStateReport.hasReport()) {
            String mimeType = this.graphDBStateReport.getReportMimeType();
            httpServletResponse.setHeader("Content-type", mimeType);
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + this.getFilenameForTimestamp(this.getLastModified(), mimeType));
        }
        httpServletResponse.setHeader("Content-Length", String.valueOf(this.graphDBStateReport.getReportFileLength()));
        String result = this.graphDBStateReport.writeReportToStream((OutputStream)httpServletResponse.getOutputStream());
        if (result != null) {
            httpServletResponse.sendError(404, result);
        } else {
            httpServletResponse.setStatus(200);
        }
    }

    @Operation(summary="Generate New Report", description="Starts report generation if no report is currently in progress.", responses={@ApiResponse(responseCode="102", description="Processing", content={@Content}), @ApiResponse(responseCode="202", description="Accepted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="skipReports", description="Types of reports to skip"), @Parameter(name="noExtra", description="Whether to skip additional details"), @Parameter(name="useTar", description="Whether to generate the report in TAR format")})
    @RequestMapping(method={RequestMethod.POST})
    private void processPostRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (GraphDBStateReport.ReportState.IN_PROGRESS.equals((Object)this.graphDBStateReport.getReportState())) {
            httpServletResponse.setStatus(102);
        } else {
            String[] skipReports = httpServletRequest.getParameterValues("skipReports");
            boolean noExtra = Boolean.parseBoolean(httpServletRequest.getParameter("noExtra"));
            boolean useTar = Boolean.parseBoolean(httpServletRequest.getParameter("useTar"));
            this.graphDBStateReport.generateReportForCurrentGDB(skipReports, noExtra, useTar);
            httpServletResponse.setStatus(202);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFilenameForTimestamp(long timestamp, String mimeType) {
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            String extension = "bin";
            if ("application/zip".equals(mimeType)) {
                extension = "zip";
            } else if ("application/tar".equals(mimeType)) {
                extension = "tar";
            }
            return String.format("graphdb-server-report-%s.%s", this.sdf.format(new Date(timestamp)), extension);
        }
    }

    private long getLastModified() throws IOException {
        Path reportZipFile = this.graphDBStateReport.getLastReportFile();
        long lastModified = 0L;
        if (reportZipFile != null) {
            lastModified = Files.getLastModifiedTime(reportZipFile, new LinkOption[0]).toMillis();
        }
        return lastModified;
    }
}

