/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sesame;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.sesame.PlaceholderRepositoryManagerWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.HandlerMapping;

public class ForestRepositoryInterceptor
extends RepositoryInterceptor {
    private static final String REPOSITORY_ENDPOINT = "/repositories/*";
    private static final String REPOSITORY_HEALTH_ENDPOINT = "/repositories/*/health";
    private static final String REPOSITORY_CONFIG_ENDPOINT = "/repositories/*/config";
    @Autowired
    private SemanticDataManagement dataManagement;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RepositoryManager repositoryManager = this.dataManagement.getLocationFromHeaderOrThrow().sesameManager();
        if (this.needsRepoIdOnly(request)) {
            repositoryManager = new PlaceholderRepositoryManagerWrapper(repositoryManager);
        }
        this.setRepositoryManager(repositoryManager);
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        MDC.remove((String)"headers");
        super.afterCompletion(request, response, handler, exception);
    }

    private boolean needsRepoIdOnly(HttpServletRequest request) {
        String bestMatchingPattern;
        switch (bestMatchingPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)) {
            case "/repositories/*/health": {
                return true;
            }
            case "/repositories/*": {
                return HttpMethod.DELETE.matches(request.getMethod()) || HttpMethod.PUT.matches(request.getMethod());
            }
            case "/repositories/*/config": {
                return HttpMethod.GET.matches(request.getMethod());
            }
        }
        return false;
    }
}

