/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.SourceLocation;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class UnionTypeOrderValidator
implements OperationValidator {
    public OperationResponse visit(Query query, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        this.validate((Selectable)query, response);
        return response;
    }

    private void validate(Selectable selectable, OperationResponse response) {
        Optional order;
        if (this.isUnionType(selectable) && (order = selectable.getArguments().getOrder()).isPresent()) {
            Set requestedFragments = selectable.getSelections().stream().filter(Selectable::isRequestedByUser).filter(Selectable::isInFragment).map(Selectable::getDefinedInType).flatMap(this.expandAbstractShapes()).map(Shape::asGraphQl).collect(Collectors.toSet());
            ((List)order.get()).stream().map(current -> current.getObjectReferenceChain().stream().findFirst().orElse(null)).filter(Objects::nonNull).map(this::removeIf).filter(shapeName -> !requestedFragments.contains(shapeName)).forEach(shapeName -> response.addWarningMessage((Serializable)this.createWarning(selectable.getLocation(), (String)shapeName)));
        }
        selectable.getSelections().stream().filter(Selectable::isRequestedByUser).forEach(selection -> this.validate((Selectable)selection, response));
    }

    private boolean isUnionType(Selectable selectable) {
        return selectable.getShapeType().filter(Shape::isUnion).isPresent();
    }

    private String removeIf(String string) {
        if (string.startsWith("_if")) {
            return string.substring("_if".length());
        }
        return string;
    }

    @NotNull
    private Function<Shape, Stream<? extends Shape>> expandAbstractShapes() {
        return shape -> {
            if (shape.isAbstract()) {
                return shape.getConcreteSubTypes().stream();
            }
            return Stream.of(shape);
        };
    }

    @VisibleForTesting
    @NotNull
    protected SimpleGraphQlError createWarning(SourceLocation location, String shapeName) {
        return new SimpleGraphQlError(Severity.WARN, ErrorMessages.get((String)"warn.union.type.order.requested.without.explicit.fragment", (Object[])new Object[]{shapeName}), List.of(new graphql.language.SourceLocation(location.getLine(), location.getColumn())), null, null);
    }
}

