/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.models.OperationValidator;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;

public class QueryExplainValidator
implements OperationValidator {
    public OperationResponse visit(Query query, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        Arguments arguments = query.getArguments();
        if ((arguments.isFromExplainGraph() || arguments.isFromSparqlGraph()) && !this.isGraphQlExplainEnabled(query.getSchema())) {
            response.addErrorMessage("query.explain.not.allowed");
        }
        return response;
    }

    private boolean isGraphQlExplainEnabled(SomlSchema schema) {
        return schema.getConfig().isGraphQlExplainEnabled().orElse(true);
    }
}

