/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Selectable;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Query;
import com.ontotext.validator.query.ExpressionServiceCollector;
import java.util.Optional;

public class FederatedFilterValidator
implements OperationValidator {
    private ExpressionServiceCollector serviceCollector = new ExpressionServiceCollector();

    public OperationResponse visit(Query query, ValidationContext context) {
        OperationResponse response = new OperationResponse();
        this.validateSelectable((Selectable)query, response);
        return response;
    }

    private void validateSelectable(Selectable selectable, OperationResponse response) {
        Optional where;
        if (selectable.getService() != null && (where = selectable.getArguments().getWhere()).isPresent() && this.serviceCollector.containsLocalShapes((ExpressionValue)where.get())) {
            response.addErrorMessage(ErrorMessages.get((String)"federated.object.with.nonfederated.filter", (Object[])new Object[]{selectable.getName(), selectable.getType()}));
        }
        for (Selectable selection : selectable.getSelections()) {
            this.validateSelectable(selection, response);
        }
    }
}

