/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.mutation;

import com.ontotext.models.MutationValidator;
import com.ontotext.models.Operation;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.SourceLocation;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RdfPropertyOperationValidator
extends MutationValidator {
    public OperationResponse validate(Operation operation, ValidationContext context) {
        if (!(operation instanceof UpdateMutation) || !context.getValidatorOptions().isValidatorEnabled(((Object)((Object)this)).getClass().getSimpleName())) {
            return OperationResponse.EMPTY;
        }
        UpdateMutation mutation = (UpdateMutation)operation;
        OperationResponse response = new OperationResponse();
        for (Change change : mutation.getChanges()) {
            Map changesByName = change.getChanges().stream().collect(Collectors.groupingBy(PropertyChange::getName, Collectors.toSet()));
            changesByName.keySet().removeIf(this.singleValueProperty(change).or(this.objectProperty(change)));
            changesByName.values().removeIf(this.isSingleChange().or(this.doesNotHaveReplace()));
            changesByName.keySet().forEach(this.reportNotAllowed((Mutation)mutation, response));
        }
        return response;
    }

    private Predicate<String> objectProperty(Change change) {
        return property -> !change.getPropertyChangeShape(property).isScalarType();
    }

    private Predicate<String> singleValueProperty(Change change) {
        return property -> !change.getPropertyChangeShape(property).isMultivalued();
    }

    private Consumer<String> reportNotAllowed(Mutation mutation, OperationResponse response) {
        return property -> response.add((OperationResponse.OperationMessage)QueryValidationMessage.error((SourceLocation)mutation.getLocation(), (String)"not.allowed.to.mix.update.and.replace", (Object[])new Object[]{mutation.getName(), property}));
    }

    private Predicate<Set<PropertyChange>> isSingleChange() {
        return propertyChanges -> propertyChanges.size() == 1;
    }

    private Predicate<Set<PropertyChange>> doesNotHaveReplace() {
        return propertyChanges -> propertyChanges.stream().noneMatch(PropertyChange::isReplace);
    }
}

