/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VersionInfoValidator
implements SchemaValidator {
    private static final Pattern VALID_VERSION = Pattern.compile("\\d+(?:\\.\\d+){0,2}(?:-\\w+)?");

    public OperationResponse validate(SomlSchema somlSchema) {
        String versionInfo = somlSchema.getVersionInfo();
        versionInfo = StringUtils.trimToNull((String)versionInfo);
        somlSchema.setVersionInfo(versionInfo);
        OperationResponse response = new OperationResponse();
        if (versionInfo != null && !VALID_VERSION.matcher(versionInfo).matches()) {
            response.addErrorMessage("soml.invalid.versionInfo", new Object[]{versionInfo});
        }
        return response;
    }
}

