/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.search.SearchConfig;
import com.ontotext.models.search.Type;
import com.ontotext.models.search.Types;
import java.io.Serializable;

public class SearchTypeConfigValidator
implements SchemaValidator {
    private static final String CONFIGURATION_KEY = "search.maxNestingLevel";
    private static final String GDB_CONFIGURATION_KEY = "graphdb.graphql.search.maxNestingLevel";
    private int maxNestingLevel = 5;

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        somlSchema.getConfig().getSearch().ifPresent(search -> this.notAllowedToSetType(response, (SearchConfig)search, null));
        Shapes shapes = somlSchema.getObjects();
        this.validateTypeOnProperties(response, null, somlSchema.getProperties());
        for (Shape shape : shapes.values()) {
            SearchConfig searchConfig = shape.getSearchSafe();
            if (!shapes.isTracked(shape.getId()) || !searchConfig.isSearchable() && !searchConfig.isNested().booleanValue()) continue;
            this.notAllowedToSetType(response, searchConfig, shape);
            this.validateTypeOnProperties(response, shape, shape.getProps());
        }
        return response;
    }

    private void validateTypeOnProperties(OperationResponse response, Shape shape, Properties properties) {
        for (PropertyShape property : properties.values()) {
            if (!properties.isTracked(property.getName()) || !property.isSearchable()) continue;
            this.checkForTypeCompatibility(shape, property, response);
            this.checkForValidTypeValue(shape, property, response);
        }
    }

    private void notAllowedToSetType(OperationResponse response, SearchConfig config, Shape shape) {
        if (config == null || !config.isTracked("type") || config.getType() == null) {
            return;
        }
        Type type = config.getType();
        if (type.getName() != null && !type.isDefault()) {
            if (shape == null) {
                response.addWarningMessage((Serializable)((Object)"property.search.typeNotAllowed.atRoot"));
            } else {
                response.addWarningMessage("property.search.typeNotAllowed.object", new Object[]{shape.getId()});
            }
        }
        Integer nestingLevel = type.getNestingLevel();
        if (type.isTracked("nestingLevel") && nestingLevel != null && this.isNestingLevelOutsideAllowedRange(nestingLevel)) {
            if (shape == null) {
                response.addErrorMessage("property.search.type.invalidNestingLevel.atRoot", new Object[]{nestingLevel, 0, this.maxNestingLevel});
            } else {
                response.addErrorMessage("property.search.type.invalidNestingLevel.atType", new Object[]{shape.getId(), nestingLevel, 0, this.maxNestingLevel});
            }
        }
    }

    private void checkForTypeCompatibility(Shape shape, PropertyShape property, OperationResponse response) {
        Type type = property.getSearch().getType();
        if (type == null || !type.isTracked("name")) {
            return;
        }
        if (property.isObjectType() ^ type.isRelationType() && !type.isDefault()) {
            if (shape != null) {
                response.addErrorMessage("property.search.typeNotCompatible.inType", new Object[]{shape.getId(), property.getName(), property.getRange(), type.getName()});
            } else {
                response.addErrorMessage("property.search.typeNotCompatible", new Object[]{property.getName(), property.getRange(), type.getName()});
            }
        }
    }

    private void checkForValidTypeValue(Shape shape, PropertyShape property, OperationResponse response) {
        Type type = property.getSearch().getType();
        if (type == null) {
            return;
        }
        this.checkTypeName(shape, property, response, type);
        this.checkNestingLevel(shape, property, response, type);
        this.warnIfKeywordTypeWithAnalysis(shape, property, response, type);
    }

    private void checkTypeName(Shape shape, PropertyShape property, OperationResponse response, Type type) {
        if (property.isScalarType() && type.isTracked("name") && !type.isRelationType() && !Types.SUPPORTED_SCALAR_TYPES.contains(type.getName())) {
            if (shape != null) {
                response.addErrorMessage("property.search.type.invalid.inType", new Object[]{shape.getId(), property.getName(), type.getName()});
            } else {
                response.addErrorMessage("property.search.type.invalid", new Object[]{property.getName(), type.getName()});
            }
        }
    }

    private void checkNestingLevel(Shape shape, PropertyShape property, OperationResponse response, Type type) {
        Integer nestingLevel = type.getNestingLevel();
        if (!type.isTracked("nestingLevel") || nestingLevel == null) {
            return;
        }
        if (property.isObjectType()) {
            if (this.isNestingLevelOutsideAllowedRange(nestingLevel)) {
                if (shape == null) {
                    response.addErrorMessage("property.search.type.invalidNestingLevel", new Object[]{property.getName(), nestingLevel, 0, this.maxNestingLevel});
                } else {
                    response.addErrorMessage("property.search.type.invalidNestingLevel.inType", new Object[]{shape.getId(), property.getName(), nestingLevel, 0, this.maxNestingLevel});
                }
            }
        } else if (shape == null) {
            response.addWarningMessage("property.search.nestingLevelNotCompatible", new Object[]{property.getName(), property.getRange(), nestingLevel});
        } else {
            response.addWarningMessage("property.search.nestingLevelNotCompatible.inType", new Object[]{shape.getId(), property.getName(), property.getRange(), nestingLevel});
        }
    }

    private boolean isNestingLevelOutsideAllowedRange(Integer nestingLevel) {
        return nestingLevel < 0 || nestingLevel > this.maxNestingLevel;
    }

    private void warnIfKeywordTypeWithAnalysis(Shape shape, PropertyShape property, OperationResponse response, Type type) {
        if (property.isObjectType()) {
            return;
        }
        if ("keyword".equals(type.getName()) && property.getSearch().getAnalysis() != null && property.getSearch().isTracked("analysis")) {
            if (shape == null) {
                response.addWarningMessage("property.search.type.and.analisys.configurations", new Object[]{property.getName(), type.getName()});
            } else {
                response.addWarningMessage("property.search.type.and.analisys.configurations.inType", new Object[]{shape.getId(), property.getName(), type.getName()});
            }
        }
    }

    public void configure(ConfigurationResolver resolver) {
        Integer value = (Integer)resolver.resolve(GDB_CONFIGURATION_KEY, Integer.class, null);
        if (value != null) {
            this.maxNestingLevel = value;
            return;
        }
        this.maxNestingLevel = (Integer)resolver.resolve(CONFIGURATION_KEY, Integer.class, (Object)5);
    }
}

