/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.graphql.parser.argument.WhereArgumentParser;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.sparql.Rdf4jInputValueConverter;

public class SearchFilterValidator
implements SchemaValidator {
    private static final String OBJECT_FILTER_INVALID = "object.filter.invalid";
    private static final WhereArgumentParser WHERE_ARGUMENT_PARSER = new WhereArgumentParser((InputValueConverter)new Rdf4jInputValueConverter());

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        somlSchema.getObjects().values().stream().filter(shape -> shape.getSearchSafe().getFilter() != null).forEach(shape -> this.validateShapeWithFilter((Shape)shape, response));
        return response;
    }

    private void validateShapeWithFilter(Shape shape, OperationResponse response) {
        String filter = shape.getSearch().getFilter();
        try {
            WHERE_ARGUMENT_PARSER.parseFromString(filter, shape);
        }
        catch (Exception ex) {
            response.addErrorMessage(OBJECT_FILTER_INVALID, new Object[]{shape.getId(), filter, ex.getMessage()});
        }
    }
}

