/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertiesDefaultValues;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class SearchConfigValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema soml) {
        OperationResponse response = new OperationResponse();
        this.validateShapes(soml.getObjects(), response);
        this.validateNoFilterConfigOnGlobalProps(soml, response);
        return response;
    }

    private void validateShapes(Shapes shapes, OperationResponse response) {
        this.checkForMisconfiguredProperties(shapes, response);
    }

    private void checkForMisconfiguredProperties(Shapes shapes, OperationResponse response) {
        ArrayList<Shape> searchableShapes = new ArrayList<Shape>(shapes.size());
        ArrayList<Shape> notSearchableShapes = new ArrayList<Shape>(shapes.size());
        for (Shape shape : shapes.values()) {
            this.validateNestedOnRootLevel(response, shape);
            if (shape.isSearchable()) {
                searchableShapes.add(shape);
                continue;
            }
            if (shape.isSystem()) continue;
            notSearchableShapes.add(shape);
        }
        this.validateSearchableShapes(response, searchableShapes);
        this.validateNotSearchableShapes(response, notSearchableShapes);
    }

    private void validateNestedOnRootLevel(OperationResponse response, Shape shape) {
        if (shape.getSearchSafe().isNested().booleanValue() && shape.getInherits() == null) {
            response.addWarningMessage("root.object.nested.forbidden", new Object[]{shape.getId()});
        }
    }

    private void validateSearchableShapes(OperationResponse response, List<Shape> searchableShapes) {
        searchableShapes.forEach(shape -> {
            this.validateSearchableConfigInheritance(response, (Shape)shape);
            this.validateDecimalProperties(response, (Shape)shape);
            this.validateNoFilterConfig(response, (Shape)shape);
        });
    }

    private void validateSearchableConfigInheritance(OperationResponse response, Shape shape) {
        LinkedList<Shape> hierarchy = new LinkedList<Shape>(shape.getContainedIn().getHierarchy(shape.getId()));
        hierarchy.removeIf(obj -> Shapes.TYPES_THAT_NOT_INHERIT_OBJECT.contains(obj.getId()));
        HashMap<String, List<String>> parentsWithDifferentConfig = new HashMap<String, List<String>>();
        for (PropertyShape property : shape.getAllProperties().values()) {
            String propertyName = property.getName();
            for (Shape parent : hierarchy) {
                parent.getProperty(propertyName).filter(PropertyShape::isSearchable).ifPresent(parentProp -> {
                    if (!property.isSearchable()) {
                        parentsWithDifferentConfig.computeIfAbsent(propertyName, key -> new ArrayList()).add(parent.getId());
                    }
                });
            }
        }
        parentsWithDifferentConfig.forEach(this.addError(response, shape));
    }

    private void validateNoFilterConfig(OperationResponse response, Shape shape) {
        Collection properties = shape.getAllProperties().values();
        for (PropertyShape prop : properties) {
            String propPath = shape.getId() + "." + prop.getName();
            this.validateSearchFilter(response, prop, propPath);
            this.validateNested(response, prop, propPath);
        }
    }

    private void validateNoFilterConfigOnGlobalProps(SomlSchema soml, OperationResponse response) {
        Collection properties = soml.getProperties().values();
        for (PropertyShape prop : properties) {
            String propPath = prop.getName();
            this.validateSearchFilter(response, prop, propPath);
            this.validateNested(response, prop, propPath);
        }
    }

    private void validateSearchFilter(OperationResponse response, PropertyShape prop, String propPath) {
        if (prop.getSearchSafe().getFilter() != null) {
            response.addErrorMessage("property.filter.forbidden", new Object[]{propPath});
        }
    }

    private void validateNested(OperationResponse response, PropertyShape prop, String propPath) {
        if (Boolean.TRUE.equals(prop.getSearchSafe().isNested())) {
            response.addErrorMessage("property.nested.forbidden", new Object[]{propPath});
        }
    }

    private BiConsumer<String, List<String>> addError(OperationResponse response, Shape shape) {
        return (property, parents) -> response.addErrorMessage("error.property.overrides.searchable.configuration", new Object[]{shape.getId(), property, String.join((CharSequence)",", parents)});
    }

    private void validateDecimalProperties(OperationResponse response, Shape shape) {
        shape.getAllProperties().values().stream().filter(this.isSearchableDecimalWithDefaultScaleFactor()).forEach(property -> response.addWarningMessage("warn.searchable.decimal.property.with.default.scale.factor", new Object[]{shape.getId(), property.getName(), property.getScaleFactor()}));
    }

    private Predicate<PropertyShape> isSearchableDecimalWithDefaultScaleFactor() {
        return property -> property.isSearchable() && property.isScalarType() && "decimal".equals(property.getScalarType().getName()) && property.getScaleFactor() == PropertiesDefaultValues.SCALE_FACTOR;
    }

    private void validateNotSearchableShapes(OperationResponse response, List<Shape> notSearchableShapes) {
        notSearchableShapes.forEach(shape -> {
            if (shape.getSearchSafe().getFilter() != null) {
                response.addWarningMessage("object.filter.nonSearchable", new Object[]{shape.getId()});
            }
            this.validateNoFilterConfig(response, (Shape)shape);
        });
    }
}

