/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PropertyRegexValidator
implements SchemaValidator {
    private static final String REGEX_INHERITANCE_CHECK = "regexInheritanceCheck";
    static final List<String> VALID_FLAGS = Stream.of("s", "m", "i", "x", "q").collect(Collectors.toList());

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Properties properties = somlSchema.getProperties();
        for (PropertyShape property : properties.values()) {
            this.validateSchemaProps(operationResponse, property);
        }
        boolean regexInheritanceCheckEnabled = somlSchema.getConfig().isCheckEnabled(REGEX_INHERITANCE_CHECK);
        for (Shape object : somlSchema.getObjects().values()) {
            if (object.isHierarchyInvalid() || object.isSynthetic().booleanValue()) continue;
            this.validateShapeProps(somlSchema, operationResponse, object, regexInheritanceCheckEnabled);
        }
        return operationResponse;
    }

    private void validateShapeProps(SomlSchema schema, OperationResponse response, Shape shape, boolean regexInheritanceEnabled) {
        Properties props = shape.getProps();
        for (PropertyShape property : props.values()) {
            String path;
            if (!props.isTracked(property.getName()) || this.arePatternOrFlagsInvalid(path = " of " + shape.getId(), property, response)) continue;
            this.checkIfRegexAndPrefixAreAllowed(path, property, response);
            List hierarchy = null;
            try {
                hierarchy = schema.getObjects().getHierarchy(shape.getId());
            }
            catch (InvalidSchemaException invalidSchemaException) {
                // empty catch block
            }
            if (regexInheritanceEnabled) {
                this.checkInheritance(property, hierarchy, response);
            }
            this.validateRegex(path, property, response);
            this.validateFlags(path, property, response);
        }
    }

    private void validateSchemaProps(OperationResponse operationResponse, PropertyShape property) {
        this.checkIfRegexAndPrefixAreAllowed("", property, operationResponse);
        if (this.arePatternOrFlagsInvalid("", property, operationResponse)) {
            return;
        }
        this.validateRegex("", property, operationResponse);
        this.validateFlags("", property, operationResponse);
    }

    private void checkInheritance(PropertyShape property, Collection<Shape> hierarchy, OperationResponse response) {
        Shape parent;
        String propName = property.getName();
        if (null == hierarchy) {
            return;
        }
        if (property.isTracked("prefix") && null != property.getPrefix()) {
            String prefix = property.getPrefix();
            Optional<Shape> parentWithPrefix = hierarchy.stream().filter(shape -> !shape.getProperty(propName).orElse(property).getPrefix().equals(prefix)).findFirst();
            if (parentWithPrefix.isPresent()) {
                parent = parentWithPrefix.get();
                String parentPrefix = parent.getPropertyOrFail(propName).getPrefix();
                response.addErrorMessage("property.redefines.inherited.prefix", new Object[]{property.getContainedIn().getContainedIn().getId(), propName, property.getPrefix(), parent.getId(), propName, parentPrefix});
            }
        }
        if (property.isTracked("pattern") && null != property.getPattern()) {
            String regex = property.getPatternString();
            Optional<Shape> parentWithRegex = hierarchy.stream().filter(shape -> !Objects.equals(shape.getProperty(propName).map(PropertyShape::getPatternString).orElse(regex), regex)).findFirst();
            if (parentWithRegex.isPresent()) {
                parent = parentWithRegex.get();
                String parentRegex = ((PropertyShape)parent.getProperty(propName).orElseThrow(() -> new InvalidSchemaException("Unknown parent."))).getPatternString();
                response.addErrorMessage("property.redefines.inherited.regex", new Object[]{property.getContainedIn().getContainedIn().getId(), propName, property.getPatternString(), parent.getId(), propName, parentRegex});
            }
        }
    }

    private void checkIfRegexAndPrefixAreAllowed(String path, PropertyShape property, OperationResponse response) {
        if (property.isTracked("pattern") && property.getPattern() != null || property.isTracked("prefix") && property.getPrefix() != null) {
            if (!property.isScalarType() && !"iri".equals(property.getRange())) {
                response.addErrorMessage("property.invalid.use.of.regex.or.prefix", new Object[]{property.getName(), path, property.getRange()});
            }
            if (property.isScalarType() && !property.getScalarType().treatedAsString()) {
                response.addWarningMessage("property.invalid.use.of.regex.non.string", new Object[]{property.getName(), path});
            }
        }
    }

    private void validateRegex(String path, PropertyShape property, OperationResponse response) {
        if (property.isTracked("pattern") && StringUtils.isNotBlank((CharSequence)property.getPatternString())) {
            try {
                Pattern.compile(property.getPatternString());
            }
            catch (PatternSyntaxException pse) {
                response.addErrorMessage("property.invalid.regex", new Object[]{property.getName(), path, property.getPatternString(), pse.getMessage()});
            }
        }
    }

    private void validateFlags(String path, PropertyShape property, OperationResponse response) {
        String flags;
        String[] tokenizedFlags;
        if (property.isTracked("pattern") && property.getPatternAndFlags() instanceof List && ((List)property.getPatternAndFlags()).size() > 1 && !VALID_FLAGS.containsAll(Arrays.asList(tokenizedFlags = (flags = (String)((List)property.getPatternAndFlags()).get(1)).toLowerCase().split("(?!^)")))) {
            response.addErrorMessage("property.invalid.regex.flags", new Object[]{property.getName(), path, flags, VALID_FLAGS});
        }
    }

    private boolean arePatternOrFlagsInvalid(String path, PropertyShape property, OperationResponse response) {
        if (!property.isTracked("pattern") || property.getPatternAndFlags() == null) {
            return false;
        }
        Object patternAndFlags = property.getPatternAndFlags();
        if (patternAndFlags instanceof List) {
            if (!((List)patternAndFlags).stream().allMatch(item -> item instanceof String)) {
                response.addErrorMessage("property.validation.pattern.datatype", new Object[]{property.getName(), path, property.getPattern()});
                return true;
            }
        } else if (!(patternAndFlags instanceof String)) {
            response.addErrorMessage("property.validation.pattern.datatype", new Object[]{property.getName(), path, property.getPattern()});
            return true;
        }
        return false;
    }
}

