/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PropertyRangeValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (PropertyShape property : somlSchema.getProperties().values()) {
            this.checkPropertyRange(property, operationResponse, "", objects);
        }
        for (Shape shape : objects.values()) {
            if (!objects.isTracked(shape.getId()) || shape.isHierarchyInvalid() || shape.isSynthetic().booleanValue()) continue;
            String path = " of " + shape.getId();
            for (PropertyShape property : shape.getProps().values()) {
                if (!shape.getProps().isTracked(property.getName())) continue;
                this.checkPropertyRange(property, operationResponse, path, objects);
                this.checkInheritedRange(objects, shape, property, operationResponse);
                this.checkRangeCheck(property, path, operationResponse);
            }
        }
        return operationResponse;
    }

    private void checkRangeCheck(PropertyShape property, String path, OperationResponse errors) {
        if (Boolean.TRUE.equals(property.getRangeCheck()) && property.isScalarType()) {
            errors.addErrorMessage("property.uses.range.check.for.scalar", new Object[]{property.getName(), path});
        }
    }

    private void checkPropertyRange(PropertyShape property, OperationResponse errors, String path, Shapes objects) {
        if (property.isTracked("range") && !property.isScalarType() && !objects.containsKey((Object)property.getRange())) {
            errors.addErrorMessage("property.use.undefined.range", new Object[]{property.getName(), path, property.getRange()});
        }
    }

    private void checkInheritedRange(Shapes objects, Shape currentObject, PropertyShape property, OperationResponse operationResponse) {
        ArrayList<Shape> hierarchy;
        try {
            hierarchy = new ArrayList<Shape>(objects.getHierarchy(currentObject.getId()));
            hierarchy.removeIf(obj -> obj.getId().equals(currentObject.getId()));
        }
        catch (InvalidSchemaException ise) {
            return;
        }
        String simpleName = property.getContainedIn().simplifyName(property.getName());
        hierarchy.stream().filter(object -> this.hasMatchingName(simpleName, property, (Shape)object)).filter(this.isNotSameRange(property, simpleName).and(this.isAnyScalar(property).or(this.isNotCovariantOfTheParentType(objects, property)))).forEach(this.reportError(operationResponse, currentObject, property));
    }

    private boolean hasMatchingName(String simpleName, PropertyShape property, Shape object) {
        return object.getProps().containsKey((Object)property.getName()) || object.getProps().containsKey((Object)simpleName);
    }

    private Consumer<? super Shape> reportError(OperationResponse operationResponse, Shape currentObject, PropertyShape property) {
        return parent -> {
            String conflictingPropName = null != parent.getProps().get((Object)property.getName()) ? property.getName() : property.getContainedIn().simplifyName(property.getName());
            operationResponse.addErrorMessage("property.range.not.covariant", new Object[]{currentObject.getId(), property.getName(), property.getRange(), parent.getProperty(conflictingPropName).orElse((PropertyShape)parent.getProps().get((Object)conflictingPropName)).getRange(), parent.getId(), conflictingPropName});
        };
    }

    private Predicate<Shape> isNotSameRange(PropertyShape baseProperty, String simpleName) {
        return parent -> !parent.getProperty(baseProperty.getName()).orElse((PropertyShape)parent.getProps().get((Object)simpleName)).getRange().equals(baseProperty.getRange());
    }

    private Predicate<Shape> isAnyScalar(PropertyShape property) {
        return object -> property.isScalarType() || ((PropertyShape)object.getProps().get((Object)property.getName())).isScalarType();
    }

    private Predicate<Shape> isNotCovariantOfTheParentType(Shapes objects, PropertyShape property) {
        return parent -> {
            Set<String> parentTypeHierarchy;
            PropertyShape parentProperty = (PropertyShape)parent.getProps().get((Object)property.getName());
            Set<String> currentTypeHierarchy = this.getPropertyHierarchyTypes(objects, property);
            return !currentTypeHierarchy.containsAll(parentTypeHierarchy = this.getPropertyHierarchyTypes(objects, parentProperty));
        };
    }

    private Set<String> getPropertyHierarchyTypes(Shapes objects, PropertyShape property) {
        try {
            return objects.getHierarchy(property.getRange()).stream().map(Shape::getId).collect(Collectors.toSet());
        }
        catch (InvalidSchemaException ise) {
            return Collections.emptySet();
        }
    }
}

