/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Prefixes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import com.ontotext.validator.PrefixesValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PrefixesValidator
implements SchemaValidator {
    private static final List<String> IANA_SCHEMAS = Stream.of("http", "https", "mailto", "urn", "geo", "tel", "ssh", "ftp", "git").collect(Collectors.toList());
    private static final Map<String, String> INTERNAL_PREFIXES = new LinkedHashMap<String, String>();

    public OperationResponse validate(SomlSchema schema) {
        OperationResponse response = new OperationResponse();
        Prefixes prefixes = schema.getPrefixes();
        this.checkForIanaRegisteredPrefixes(response, prefixes);
        HashMap<String, List<String>> ambiguousNamespace = new HashMap<String, List<String>>(prefixes.size());
        HashMap<String, List<String>> ambiguousIris = new HashMap<String, List<String>>(prefixes.size());
        for (Map.Entry entry : prefixes.entrySet()) {
            String namespace = (String)entry.getKey();
            if (!prefixes.isTracked(namespace)) continue;
            this.validateNamespaces(response, ambiguousNamespace, namespace);
            this.validateIris(response, ambiguousIris, namespace, (String)entry.getValue());
        }
        this.checkForAmbiguousPrefixDefinitions(response, ambiguousNamespace, ambiguousIris, schema);
        this.validateInternalPrefixes(response, prefixes);
        this.validateVocabPrefix(response, schema);
        return response;
    }

    private void checkForIanaRegisteredPrefixes(OperationResponse operationResponse, Prefixes prefixes) {
        IANA_SCHEMAS.stream().filter(arg_0 -> prefixes.containsKey(arg_0)).forEach(sensitive -> operationResponse.addWarningMessage("ianaRegistered.prefix", new Object[]{sensitive}));
    }

    private void validateNamespaces(OperationResponse operationResponse, Map<String, List<String>> ambiguousNamespace, String namespace) {
        if (!ValidationPatterns.PREFIX_PATTERN.matcher(namespace).matches()) {
            operationResponse.addErrorMessage("invalid.prefix", new Object[]{namespace});
        } else {
            ambiguousNamespace.computeIfAbsent(StringUtils.uncapitalize((String)namespace), key -> new ArrayList(2)).add(namespace);
        }
    }

    private void validateIris(OperationResponse operationResponse, Map<String, List<String>> ambiguousIris, String namespace, String iri) {
        if (!ValidationPatterns.isValidIri((String)iri)) {
            operationResponse.addErrorMessage("invalid.prefix.iri", new Object[]{namespace, iri});
        } else {
            ambiguousIris.computeIfAbsent(iri, key -> new ArrayList(2)).add(namespace);
        }
    }

    private void checkForAmbiguousPrefixDefinitions(OperationResponse operationResponse, Map<String, List<String>> ambiguousNamespaces, Map<String, List<String>> ambiguousIris, SomlSchema schema) {
        ambiguousNamespaces.values().stream().filter(values -> values.size() > 1).forEach(values -> operationResponse.addErrorMessage("ambiguous.prefix", new Object[]{values}));
        Set usedNamespces = Collections.emptySet();
        ambiguousIris.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).filter(entry -> this.areUsed(schema, usedNamespces, (List)entry.getValue())).forEach(entry -> operationResponse.addErrorMessage("duplicated.prefix.iri", new Object[]{entry.getKey(), entry.getValue()}));
    }

    private boolean areUsed(SomlSchema schema, Set<String> usedNamespces, List<String> namespces) {
        if (usedNamespces.isEmpty()) {
            usedNamespces = PrefixesValidationUtil.collectUsedNamespaces(schema);
        }
        HashSet<String> copy = new HashSet<String>(usedNamespces);
        copy.retainAll(namespces);
        return copy.size() > 1;
    }

    private void validateInternalPrefixes(OperationResponse operationResponse, Prefixes prefixes) {
        INTERNAL_PREFIXES.forEach((prefix, namespace) -> {
            if (prefixes.containsKey(prefix) && !namespace.equals(prefixes.get(prefix))) {
                operationResponse.addErrorMessage("forbid.internal.prefix.change", new Object[]{prefix, prefixes.get(prefix)});
            }
        });
    }

    private void validateVocabPrefix(OperationResponse operationResponse, SomlSchema schema) {
        Prefixes prefixes = schema.getPrefixes();
        HashMap prefixesCopy = new HashMap(prefixes);
        String vocabPrefix = prefixes.getVocabPrefix().orElse("");
        String vocabIri = schema.getSpecialPrefixes().getVocabIri().orElse("");
        prefixesCopy.remove(vocabPrefix, vocabIri);
        prefixesCopy.keySet().stream().map(StringUtils::uncapitalize).filter(StringUtils.uncapitalize((String)vocabPrefix)::equals).findFirst().ifPresent(prefix -> operationResponse.addErrorMessage("ambiguous.prefix", new Object[]{Arrays.asList(prefix, vocabPrefix)}));
    }

    static {
        INTERNAL_PREFIXES.put("res", "http://www.ontotext.com/semantic-object/result/");
        INTERNAL_PREFIXES.put("so", "http://www.ontotext.com/semantic-object/");
    }
}

