/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class NamesValidator
implements SchemaValidator {
    private static final String VOCAB_PFX_PROP = "vocab_prefix";
    private static final Set<String> RESERVED_WORDS = Stream.of("__typename", "id", "name", "type", "value", "lang", "Object", "Literal", "Nameable").collect(Collectors.toSet());
    private static final Set<String> ALLOW_PARTIAL_OVERWRITE = Stream.of("id", "name", "type").collect(Collectors.toSet());
    private static final Set<String> RESERVED_OBJECT_NAMES = Stream.of("Literal", "Nameable").collect(Collectors.toSet());

    public OperationResponse validate(SomlSchema somlSchema) {
        Prefixes prefixes = somlSchema.getPrefixes();
        String vocabPrefix = somlSchema.getSpecialPrefixes().getVocabPrefix().orElse("");
        OperationResponse operationResponse = new OperationResponse();
        for (String propName : somlSchema.getProperties().keySet()) {
            NamesValidator.validatePropertyName("", propName, operationResponse, prefixes);
            this.validateVocabCollation("", propName, operationResponse, somlSchema.getProperties().keySet(), vocabPrefix);
        }
        Shapes objects = somlSchema.getObjects();
        for (Shape object : objects.values()) {
            String objName = object.getId();
            if (!objects.isTracked(objName) || object.isHierarchyInvalid() || object.isSynthetic().booleanValue()) continue;
            NamesValidator.validateObjectName(objName, operationResponse, prefixes);
            this.validateVocabCollation("", objName, operationResponse, objects.keySet(), vocabPrefix);
            this.checkForScalarDuplication(objName, operationResponse, prefixes, somlSchema.getTypes());
            Properties props = object.getProps();
            for (PropertyShape propertyShape : props.values()) {
                String propName = propertyShape.getName();
                if (!props.isTracked(propName)) continue;
                String path = " of " + objName;
                NamesValidator.validatePropertyName(path, propName, operationResponse, prefixes);
                this.validateVocabCollation(path, propName, operationResponse, object.getProps().keySet(), vocabPrefix);
                this.checkForReservedWords(objName, propName, operationResponse, prefixes);
            }
        }
        return operationResponse;
    }

    private void validateVocabCollation(String path, String name, OperationResponse response, Set<String> extantKeys, String vocabPrefix) {
        int underScoreIdx = name.indexOf(58);
        if (underScoreIdx > 0) {
            String pseudoPrefix = name.substring(0, underScoreIdx);
            if (!pseudoPrefix.equals(vocabPrefix)) {
                return;
            }
            String unPrefixedName = name.substring(underScoreIdx + 1);
            if (extantKeys.contains(unPrefixedName) && !RESERVED_WORDS.contains(unPrefixedName)) {
                response.addErrorMessage("name.should.not.be.defined.twice", new Object[]{name, path, unPrefixedName});
            }
        }
    }

    private static void validatePropertyName(String path, String name, OperationResponse response, Prefixes prefixes) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            if (path.isEmpty()) {
                response.addErrorMessage("property.name.should.notBeEmpty");
            } else {
                response.addErrorMessage("property.name.should.notBeEmpty.inType", new Object[]{path.replace(" of ", "")});
            }
            return;
        }
        int colonIndex = name.indexOf(58);
        if (!Character.isLowerCase(name.charAt(colonIndex + 1))) {
            response.addErrorMessage("property.name.should.use.cameCase", new Object[]{name, path});
            return;
        }
        NamesValidator.reportIfStartsWithKnownPrefix(path, name, response, prefixes, colonIndex);
        Matcher matcher = ValidationPatterns.PROPERTY_NAME_PATTERN.matcher(name);
        if (matcher.find()) {
            String prefix = matcher.group(1);
            if (prefix != null && !prefixes.containsKey((Object)prefix)) {
                response.addErrorMessage("property.name.should.not.use.undefined.prefix", new Object[]{name, path, prefix});
            }
        } else {
            response.addErrorMessage("property.name.contains.not.allowed.chars", new Object[]{name, path});
        }
    }

    private static void reportIfStartsWithKnownPrefix(String path, String name, OperationResponse response, Prefixes prefixes, int colonIndex) {
        Prefixes.PrefixInfo prefixInfo = prefixes.resolvePrefixInfo(name);
        if (colonIndex == -1 && prefixInfo.isPrefixed()) {
            response.addErrorMessage("property.name.should.not.use.prefix.underscore", new Object[]{name, path, prefixInfo.getPrefix(), name.replaceFirst("_", ":"), prefixes.getVocabPrefix().orElse(VOCAB_PFX_PROP)});
        }
    }

    private static void validateObjectName(String name, OperationResponse response, Prefixes prefixes) {
        Matcher matcher = ValidationPatterns.OBJECT_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            if (prefix != null && !prefixes.containsKey((Object)prefix)) {
                response.addErrorMessage("object.name.should.not.use.undefined.prefix", new Object[]{name, prefix});
            }
        } else if (Character.isLowerCase(prefixes.resolvePrefixInfo(name).getValue().charAt(0))) {
            response.addErrorMessage("object.name.should.be.uppercased", new Object[]{name});
        } else {
            response.addErrorMessage("object.name.contains.not.allowed.chars", new Object[]{name});
        }
        if (RESERVED_OBJECT_NAMES.contains(name)) {
            response.addErrorMessage("object.name.should.not.use.reserved.word", new Object[]{name, prefixes.getVocabPrefix().orElse(VOCAB_PFX_PROP), name});
        }
    }

    private void checkForReservedWords(String objName, String name, OperationResponse operationResponse, Prefixes prefixes) {
        if (RESERVED_WORDS.contains(objName)) {
            return;
        }
        if (RESERVED_WORDS.contains(name) && !ALLOW_PARTIAL_OVERWRITE.contains(name)) {
            operationResponse.addErrorMessage("property.name.should.not.be.reserved.word", new Object[]{name, objName, prefixes.getVocabPrefix().orElse(VOCAB_PFX_PROP)});
        }
    }

    private void checkForScalarDuplication(String objName, OperationResponse operationResponse, Prefixes prefixes, ScalarTypes scalarTypes) {
        if (scalarTypes.isScalarType(objName)) {
            operationResponse.addErrorMessage("object.name.should.not.use.defined.scalar.name", new Object[]{objName, prefixes.getVocabPrefix().orElse(VOCAB_PFX_PROP), objName});
        }
    }
}

