/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class InversePropRangeValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema boml) {
        boolean enableRangeCheckValidation = boml.getConfig().isCheckEnabled("rangeCheck");
        OperationResponse resp = new OperationResponse();
        for (Shape shape : boml.getObjects().values()) {
            if (Boolean.TRUE.equals(shape.isSynthetic())) continue;
            for (PropertyShape prop : shape.getProps().values()) {
                this.validateRange(shape, prop, prop.getInverseAlias(), boml, resp);
                this.validateRange(shape, prop, prop.getInverseOf(), boml, resp);
                this.validateInverseConflict(shape, prop, resp);
                if (!enableRangeCheckValidation) continue;
                this.validateRangeCheck(shape, prop, resp);
            }
        }
        return resp;
    }

    private void validateRange(Shape parentShape, PropertyShape prop, String inverseProp, SomlSchema schema, OperationResponse resp) {
        block8: {
            String targetShape;
            block7: {
                if (inverseProp == null) {
                    return;
                }
                if (prop.getRange() == null) {
                    return;
                }
                Shape target = (Shape)schema.getObjects().get((Object)prop.getRange());
                if (target == null) {
                    return;
                }
                PropertyShape actualProp = target.getProperty(inverseProp).orElse(null);
                if (actualProp == null) {
                    return;
                }
                targetShape = actualProp.getRange();
                if (actualProp.isScalarType()) break block7;
                if (!schema.getObjects().getHierarchy(parentShape.getId()).stream().map(Shape::getId).noneMatch(this.getRangeHierarchy(schema, targetShape)::contains)) break block8;
            }
            resp.addErrorMessage("property.inverse.invalid.range", new Object[]{parentShape.getId(), prop.getName(), prop.getRange(), inverseProp, targetShape});
        }
    }

    @NotNull
    private Set<String> getRangeHierarchy(SomlSchema schema, String targetShape) {
        Shape current = (Shape)schema.getObjects().get((Object)targetShape);
        if (current == null) {
            return Set.of();
        }
        if (current.isUnion()) {
            return current.getUnionOfShapes().stream().flatMap(type -> this.getRangeHierarchy(schema, type.getId()).stream()).collect(Collectors.toSet());
        }
        return schema.getObjects().getHierarchy(targetShape).stream().filter(shape -> !shape.isSystem()).map(Shape::getId).collect(Collectors.toSet());
    }

    private void validateInverseConflict(Shape shape, PropertyShape prop, OperationResponse resp) {
        if (prop.getInverseAlias() != null && prop.getInverseOf() != null && prop.getRange() != null) {
            resp.addErrorMessage("property.inverse.conflict", new Object[]{shape.getId(), prop.getName(), prop.getRange(), prop.getInverseAlias(), prop.getRange(), prop.getInverseOf()});
        }
    }

    private void validateRangeCheck(Shape shape, PropertyShape prop, OperationResponse resp) {
        String inverseAlias = prop.getInverseAlias();
        if (inverseAlias != null && Boolean.FALSE.equals(prop.getRangeCheck())) {
            resp.addErrorMessage("property.inverse.invalid.rangeCheck", new Object[]{shape.getId(), prop.getName(), inverseAlias});
        }
    }
}

