/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.InverseExpression;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.impl.MappingComponentImpl;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public abstract class TermMapImpl
extends MappingComponentImpl
implements TermMap {
    TermMap.TermMapType termMapType;
    IRI termTypeIRI;
    Template template;
    RDFTerm constVal;
    String columnName;
    InverseExpression inverseExp;

    TermMapImpl(RDF rdf, Template template) {
        super(rdf);
        this.template = Objects.requireNonNull(template);
        this.termMapType = TermMap.TermMapType.TEMPLATE_VALUED;
        this.setDefaultTermType();
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    TermMapImpl(RDF rdf, String columnName) {
        super(rdf);
        this.columnName = Objects.requireNonNull(columnName);
        this.termMapType = TermMap.TermMapType.COLUMN_VALUED;
        this.setDefaultTermType();
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    TermMapImpl(RDF rdf, RDFTerm constant) {
        super(rdf);
        this.constVal = Objects.requireNonNull(constant);
        if (constant instanceof BlankNode) {
            throw new IllegalArgumentException("BlankNode cannot be used as constant");
        }
        this.termTypeIRI = constant instanceof IRI ? this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI") : this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal");
        this.termMapType = TermMap.TermMapType.CONSTANT_VALUED;
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    TermMapImpl(RDF rdf) {
        super(rdf);
        this.termMapType = TermMap.TermMapType.RDF_STAR_VALUED;
        this.termTypeIRI = null;
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public TermMap.TermMapType getTermMapType() {
        return this.termMapType;
    }

    @Override
    public void setTermType(IRI typeIRI) {
        if (!this.getValidTermTypes().contains(typeIRI)) {
            throw new IllegalArgumentException(String.format("invalid term termMapType IRI: %s .", typeIRI));
        }
        switch (this.termMapType) {
            case TEMPLATE_VALUED: 
            case COLUMN_VALUED: 
            case RDF_STAR_VALUED: {
                this.termTypeIRI = typeIRI;
                break;
            }
        }
    }

    @Override
    public void setTemplate(Template template) {
        this.termMapType = TermMap.TermMapType.TEMPLATE_VALUED;
        this.template = Objects.requireNonNull(template);
    }

    @Override
    public void setConstant(RDFTerm constVal) {
        this.termMapType = TermMap.TermMapType.CONSTANT_VALUED;
        this.constVal = Objects.requireNonNull(constVal);
    }

    @Override
    public void setColumn(String columnName) {
        this.termMapType = TermMap.TermMapType.COLUMN_VALUED;
        this.columnName = Objects.requireNonNull(columnName);
    }

    @Override
    public void setInverseExpression(InverseExpression invExp) {
        if (this.getTermMapType() != TermMap.TermMapType.COLUMN_VALUED && this.getTermMapType() != TermMap.TermMapType.TEMPLATE_VALUED) {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.inverseExp = invExp;
    }

    @Override
    public void setDefaultTermType() {
        this.termTypeIRI = this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI");
    }

    @Override
    public IRI getTermType() {
        return this.termTypeIRI;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public String getTemplateString() {
        return this.template.toString();
    }

    @Override
    public RDFTerm getConstant() {
        return this.constVal;
    }

    @Override
    public String getColumn() {
        return this.columnName;
    }

    @Override
    public InverseExpression getInverseExpression() {
        return this.inverseExp;
    }

    @Override
    public String getInverseExpressionString() {
        return this.inverseExp.toString();
    }

    @Override
    public void removeInverseExpression() {
        this.inverseExp = null;
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#TermMap")));
        if (this.termMapType == TermMap.TermMapType.COLUMN_VALUED) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#column"), (RDFTerm)this.getRDF().createLiteral(this.getColumn())));
        } else if (this.termMapType == TermMap.TermMapType.CONSTANT_VALUED) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#constant"), this.getConstant()));
        } else if (this.termMapType == TermMap.TermMapType.TEMPLATE_VALUED) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#template"), (RDFTerm)this.getRDF().createLiteral(this.getTemplateString())));
        }
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#termType"), (RDFTerm)this.termTypeIRI));
        if (this.getInverseExpression() != null) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#inverseExpression"), (RDFTerm)this.getRDF().createLiteral(this.getInverseExpressionString())));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.constVal == null ? 0 : this.constVal.hashCode());
        result = 31 * result + (this.getNode() == null ? 0 : this.getNode().hashCode());
        result = 31 * result + (this.termTypeIRI == null ? 0 : this.termTypeIRI.hashCode());
        result = 31 * result + (this.termMapType == null ? 0 : this.termMapType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermMapImpl)) {
            return false;
        }
        TermMapImpl other = (TermMapImpl)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.constVal == null ? other.constVal != null : !this.constVal.equals((Object)other.constVal)) {
            return false;
        }
        if (this.getNode() == null ? other.getNode() != null : !this.getNode().equals((Object)other.getNode())) {
            return false;
        }
        if (this.termTypeIRI == null ? other.termTypeIRI != null : !this.termTypeIRI.equals((Object)other.termTypeIRI)) {
            return false;
        }
        return this.termMapType == other.termMapType;
    }

    public String toString() {
        return "TermMapImpl [termMapType=" + String.valueOf((Object)this.termMapType) + ", termTypeIRI=" + String.valueOf(this.termTypeIRI) + ", template=" + String.valueOf(this.template) + ", constVal=" + String.valueOf(this.constVal) + ", columnName=" + this.columnName + ", inverseExp=" + String.valueOf(this.inverseExp) + ", node=" + String.valueOf(this.getNode()) + "]";
    }
}

