/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.Join;
import eu.optique.r2rml.api.model.impl.MappingComponentImpl;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class JoinImpl
extends MappingComponentImpl
implements Join {
    private String child;
    private String parent;

    public JoinImpl(RDF rdf, String childCol, String parentCol) {
        super(rdf);
        this.setChild(childCol);
        this.setParent(parentCol);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public void setChild(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("A Join must have a child column.");
        }
        this.child = columnName;
    }

    @Override
    public void setParent(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("A Join must have a parent column.");
        }
        this.parent = columnName;
    }

    @Override
    public String getChild() {
        return this.child;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Join")));
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#child"), (RDFTerm)this.getRDF().createLiteral(this.child)));
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#parent"), (RDFTerm)this.getRDF().createLiteral(this.parent)));
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinImpl)) {
            return false;
        }
        JoinImpl other = (JoinImpl)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }

    public String toString() {
        return "JoinImpl [child=" + this.child + ", parent=" + this.parent + ", node=" + String.valueOf(this.node) + "]";
    }
}

