/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.indexing;

import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public final class GeoFactory {
    static final int DEFAULT_DEFAULT_SRID = 4326;
    private static volatile int defaultSrid = -1;
    private static volatile GeometryFactory defaultGeometryFactory;

    public static synchronized void setDefaultSrid(int srid) {
        if (defaultSrid != -1 && defaultSrid != srid) {
            throw new IllegalStateException("Default SRID can not be changed after first use");
        }
        if (srid == -1) {
            throw new IllegalArgumentException("-1 is not a valid value for SRID");
        }
        defaultSrid = srid;
        defaultGeometryFactory = new GeometryFactory(new PrecisionModel(), defaultSrid);
    }

    public static int getDefaultSrid() {
        if (defaultSrid == -1) {
            GeoFactory.init();
        }
        return defaultSrid;
    }

    public static GeometryFactory getDefaultGeometryFactory() {
        if (defaultSrid == -1) {
            GeoFactory.init();
        }
        return defaultGeometryFactory;
    }

    static void resetForTest() {
        defaultSrid = -1;
        defaultGeometryFactory = null;
    }

    private static synchronized void init() {
        defaultSrid = 4326;
        defaultGeometryFactory = new GeometryFactory(new PrecisionModel(), defaultSrid);
    }
}

