/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql;

import com.useekm.geosparql.AbstractLiteralUnaryFunction;
import com.useekm.geosparql.LiteralFunction;
import com.useekm.indexing.GeoConstants;
import com.useekm.indexing.GeoFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.locationtech.jts.geom.Geometry;

public class GetSRID
extends AbstractLiteralUnaryFunction
implements LiteralFunction {
    public String getURI() {
        return GeoConstants.GEOF_GETSRID.stringValue();
    }

    @Override
    protected Literal evaluate(ValueFactory valueFactory, IRI geotype, Geometry geom) {
        int srid = geom.getSRID();
        if (srid <= 0) {
            srid = GeoFactory.getDefaultSrid();
        }
        return valueFactory.createLiteral(geom.getSRID());
    }
}

