/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.util;

import com.ontotext.trree.geosparql.GeoSparqlConfig;
import com.ontotext.trree.sdk.PluginException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.slf4j.Logger;

public class GeoSparqlUtils {
    public static void migrateConfig(Path pluginDataDir, Logger logger) {
        Path legacyConfigPath;
        GeoSparqlConfig config = new GeoSparqlConfig();
        Path configPath = GeoSparqlConfig.resolveConfigPath(pluginDataDir);
        if (!Files.exists(configPath, new LinkOption[0]) && Files.isReadable(legacyConfigPath = GeoSparqlConfig.resolveLegacyConfigPath(pluginDataDir))) {
            try (FileInputStream in = new FileInputStream(legacyConfigPath.toFile());){
                Properties properties = new Properties();
                properties.load(in);
                config.setFromProperties(properties);
                if (config.isEnabled()) {
                    logger.info("Detected incompatible index from a previous version. Please rebuild the index manually.");
                    config.setEnabled(false);
                }
                GeoSparqlUtils.saveConfig(config, pluginDataDir);
            }
            catch (IOException e) {
                throw new PluginException("Cannot load GeoSPARQL configuration file.", (Throwable)e);
            }
        }
    }

    public static GeoSparqlConfig readConfig(Path pluginDataDir) {
        GeoSparqlConfig config = new GeoSparqlConfig();
        Path configPath = GeoSparqlConfig.resolveConfigPath(pluginDataDir);
        if (Files.isReadable(configPath)) {
            try (FileInputStream in = new FileInputStream(configPath.toFile());){
                Properties properties = new Properties();
                properties.load(in);
                config.setFromProperties(properties);
            }
            catch (IOException e) {
                throw new PluginException("Cannot load GeoSPARQL configuration file.", (Throwable)e);
            }
        }
        return config;
    }

    public static void saveConfig(GeoSparqlConfig config, Path pluginDataDir) {
        Path configPath = GeoSparqlConfig.resolveConfigPath(pluginDataDir);
        if (!Files.exists(configPath.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PluginException("Cannot save GeoSPARQL configuration file.", (Throwable)e);
            }
        }
        try (FileOutputStream os = new FileOutputStream(configPath.toFile());){
            Properties properties = config.getAsProperties();
            properties.store(os, "GeoSPARQL configuration");
        }
        catch (IOException e) {
            throw new PluginException("Cannot save GeoSPARQL configuration file.", (Throwable)e);
        }
    }

    public static void validateParams(GeoSparqlConfig.PrefixTree prefixTree, int precision) {
        switch (prefixTree) {
            case GEOHASH: {
                if (precision > 0 && precision <= GeohashPrefixTree.getMaxLevelsPossible()) break;
                throw new PluginException(GeoSparqlUtils.constructExceptionMessage(prefixTree));
            }
            case QUAD: {
                if (precision > 0 && precision <= 50) break;
                throw new PluginException(GeoSparqlUtils.constructExceptionMessage(prefixTree));
            }
        }
    }

    private static String constructExceptionMessage(GeoSparqlConfig.PrefixTree prefixTree) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefixTree == GeoSparqlConfig.PrefixTree.QUAD ? "QUAD" : "GEOHASH").append(" prefix tree requires precision values between 1 and ").append(prefixTree == GeoSparqlConfig.PrefixTree.QUAD ? 50 : GeohashPrefixTree.getMaxLevelsPossible()).append(".");
        return sb.toString();
    }
}

