/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.lucene;

import com.ontotext.trree.geosparql.EntityGeometryIterator;
import com.ontotext.trree.geosparql.GeoSparqlIndexer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.jts.geom.Geometry;

public class LuceneMultiSearchEntityGeometryIterator
implements EntityGeometryIterator {
    private GeoSparqlIndexer indexer;
    private SpatialOperation spatialOperation;
    private EntityGeometryIterator luceneIterator;
    private List<EntityGeometryIterator> iteratorsToClose = new ArrayList<EntityGeometryIterator>();

    public LuceneMultiSearchEntityGeometryIterator(GeoSparqlIndexer indexer, SpatialOperation spatialOperation) {
        this.indexer = indexer;
        this.spatialOperation = spatialOperation;
    }

    @Override
    public long getEntityForLastGeometry() {
        return this.luceneIterator == null ? 0L : this.luceneIterator.getEntityForLastGeometry();
    }

    @Override
    public Geometry nextGeometry() {
        return this.luceneIterator == null ? null : this.luceneIterator.nextGeometry();
    }

    @Override
    public Geometry lastGeometry() {
        return this.luceneIterator == null ? null : this.luceneIterator.lastGeometry();
    }

    @Override
    public boolean hasNextGeometry() {
        return this.luceneIterator != null && this.luceneIterator.hasNextGeometry();
    }

    @Override
    public void advanceToNextEntity() {
        if (this.luceneIterator == null) {
            return;
        }
        this.luceneIterator.advanceToNextEntity();
    }

    @Override
    public void close() throws IOException {
        for (EntityGeometryIterator itty : this.iteratorsToClose) {
            itty.close();
        }
    }

    public void search(Geometry geometry) {
        this.luceneIterator = this.indexer.getMatchingObjects(geometry, this.spatialOperation);
        this.iteratorsToClose.add(this.luceneIterator);
    }
}

