/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.lucene;

import com.ontotext.trree.geosparql.EntityGeometryIterator;
import com.ontotext.trree.geosparql.lucene.LuceneGeoIndexer;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.locationtech.jts.geom.Geometry;

class LuceneEntityGeometryIterator
implements EntityGeometryIterator {
    private static final int PAGE_SIZE = 1000;
    private int page;
    private TopDocs topDocs;
    private final IndexSearcher searcher;
    private Query query;
    private int idx = -1;
    private int geoDatasIndex = 0;
    private BytesRef[] geoDatas;
    private long entityId;
    private Geometry geometry;

    LuceneEntityGeometryIterator(IndexSearcher searcher, Query query) throws IOException {
        this.searcher = searcher;
        this.query = query;
        this.topDocs = searcher.search(query, 1000);
        this.page = 1;
    }

    @Override
    public long getEntityForLastGeometry() {
        return this.entityId;
    }

    @Override
    public Geometry nextGeometry() {
        if (!this.hasNextGeometry()) {
            return null;
        }
        try {
            if (this.geoDatas != null && this.geoDatasIndex + 1 < this.geoDatas.length) {
                ++this.geoDatasIndex;
            } else if (this.idx + 1 < this.topDocs.scoreDocs.length) {
                this.advanceLuceneDocument();
            } else {
                this.advanceLucenePage();
            }
            this.geometry = LuceneGeoIndexer.fieldValueToGeometry(this.geoDatas[this.geoDatasIndex].bytes);
            return this.geometry;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Geometry lastGeometry() {
        return this.geometry;
    }

    @Override
    public boolean hasNextGeometry() {
        return this.geoDatas != null && this.geoDatasIndex + 1 < this.geoDatas.length || this.idx + 1 < this.topDocs.scoreDocs.length || (long)(this.page * 1000) < this.topDocs.totalHits.value;
    }

    @Override
    public void advanceToNextEntity() {
        this.geoDatas = null;
    }

    @Override
    public void close() throws IOException {
        this.searcher.getIndexReader().close();
    }

    private boolean advanceLucenePage() throws IOException {
        if ((long)(this.page * 1000) < this.topDocs.totalHits.value) {
            this.topDocs = this.searcher.searchAfter(this.topDocs.scoreDocs[this.topDocs.scoreDocs.length - 1], this.query, 1000);
            ++this.page;
            this.idx = -1;
            this.advanceLuceneDocument();
            return true;
        }
        return false;
    }

    private void advanceLuceneDocument() throws IOException {
        ++this.idx;
        this.geoDatasIndex = 0;
        ScoreDoc d = this.topDocs.scoreDocs[this.idx];
        Document doc = this.searcher.doc(d.doc);
        this.entityId = (Long)doc.getField("id").numericValue();
        this.geoDatas = doc.getBinaryValues("geoData");
    }
}

