/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.geosparql.EntityGeometryIterator;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public class SingleEntityGeometryIterator
implements EntityGeometryIterator {
    private final long entityId;
    private final Iterator<Geometry> iGeometries;
    private Geometry geometry;

    public SingleEntityGeometryIterator(long entityId, List<Geometry> geometries) {
        this.entityId = entityId;
        this.iGeometries = geometries != null ? geometries.iterator() : Collections.emptyIterator();
    }

    public SingleEntityGeometryIterator(long entityId, Geometry geometry) {
        this.entityId = entityId;
        this.iGeometries = geometry != null ? Collections.singletonList(geometry).iterator() : Collections.emptyIterator();
    }

    @Override
    public long getEntityForLastGeometry() {
        return this.entityId;
    }

    @Override
    public Geometry nextGeometry() {
        this.geometry = this.iGeometries.next();
        return this.geometry;
    }

    @Override
    public Geometry lastGeometry() {
        return this.geometry;
    }

    @Override
    public boolean hasNextGeometry() {
        return this.iGeometries.hasNext();
    }

    @Override
    public void advanceToNextEntity() {
    }

    @Override
    public void close() throws IOException {
    }
}

