/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util;

import co.elastic.clients.elasticsearch._types.KnnSearch;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilder;
import co.elastic.clients.elasticsearch._types.RescoreVector;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.GraphDBQuery;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.StringToVectorDeserializer;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import jakarta.json.stream.JsonParser;

public class GraphDBSearchRequestBuilder
extends SearchRequest.Builder {
    protected static final StringToVectorDeserializer TEXT_TO_VECTOR_DESERIALIZER = new StringToVectorDeserializer();
    protected static final JsonpDeserializer<KnnSearch> KNN_SEARCH_DESERIALIZER = ObjectBuilderDeserializer.lazy(KnnSearch.Builder::new, GraphDBSearchRequestBuilder::setupKnnSearchDeserializer);
    private final VectorBuilder vectorBuilder;

    public GraphDBSearchRequestBuilder(VectorBuilder vectorBuilder) {
        this.vectorBuilder = vectorBuilder;
    }

    public GraphDBSearchRequestBuilder withJson(JsonParser parser, JsonpMapper mapper) {
        JsonpDeserializer classDeser = JsonpMapperBase.findDeserializer(SearchRequest.class);
        if (classDeser == null) {
            throw new IllegalArgumentException("Class SearchRequest cannot be read from JSON");
        }
        ObjectDeserializer builderDeser = (ObjectDeserializer)DelegatingDeserializer.unwrap((JsonpDeserializer)classDeser);
        builderDeser.ignore("_source");
        builderDeser.add(SearchRequest.Builder::query, GraphDBQuery._DESERIALIZER, "query");
        builderDeser.add((rec$, x$0) -> ((SearchRequest.Builder)rec$).knn(x$0, new KnnSearch[0]), KNN_SEARCH_DESERIALIZER, "knn");
        TEXT_TO_VECTOR_DESERIALIZER.setVectorBuilder(this.vectorBuilder);
        builderDeser.deserialize((Object)this, parser, mapper, parser.next());
        return this;
    }

    private static void setupKnnSearchDeserializer(ObjectDeserializer<KnnSearch.Builder> op) {
        op.add(KnnSearch.Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(KnnSearch.Builder::queryVector, (JsonpDeserializer)TEXT_TO_VECTOR_DESERIALIZER, "query_vector");
        op.add(KnnSearch.Builder::queryVectorBuilder, QueryVectorBuilder._DESERIALIZER, "query_vector_builder");
        op.add(KnnSearch.Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(KnnSearch.Builder::numCandidates, JsonpDeserializer.integerDeserializer(), "num_candidates");
        op.add(KnnSearch.Builder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(KnnSearch.Builder::filter, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)Query._DESERIALIZER), "filter");
        op.add(KnnSearch.Builder::similarity, JsonpDeserializer.floatDeserializer(), "similarity");
        op.add(KnnSearch.Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(KnnSearch.Builder::rescoreVector, RescoreVector._DESERIALIZER, "rescore_vector");
    }

    protected void _checkSingleUse() {
    }
}

