/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.ElasticsearchUtil;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.GraphDBPropertyWrapper;
import com.ontotext.trree.sdk.ClientErrorException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;

class ElasticsearchMappingGenerator {
    static final String PROPERTIES_NAME = "properties";
    static final String[] BANNED_NATIVE_SETTINGS = new String[]{"type", "index", "store", "analyzer", "fielddata"};
    private static final Literal NON_EMPTY_LITERAL = SimpleValueFactory.getInstance().createLiteral("non-empty literal");
    private static final String GEO_POINT_LAT_LONG_TYPE = "double";
    private final Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> existingFields = new HashMap<String, co.elastic.clients.elasticsearch._types.mapping.Property>();
    private final Map<String, String> knownFieldMappings = new HashMap<String, String>();
    private final boolean hasNestedObjects;
    private boolean mappingChanged;
    private boolean mappingInitialised = false;
    private ElasticsearchDriver driver;
    private static final Map<IRI, String> XML_TYPE_TO_ELASTICSEARCH_TYPE = new HashMap<IRI, String>(){
        {
            this.put(XSD.BOOLEAN, "boolean");
            this.put(XSD.DOUBLE, ElasticsearchMappingGenerator.GEO_POINT_LAT_LONG_TYPE);
            this.put(XSD.FLOAT, "float");
            this.put(XSD.LONG, "long");
            this.put(XSD.INT, "integer");
            this.put(XSD.DATETIME, "date:strict_date_time");
            this.put(XSD.DATE, "date:strict_date");
            this.put(XSD.TIME, "date:strict_time_no_millis||strict_time");
            this.put(XSD.GYEAR, "date:strict_year");
            this.put(XSD.GYEARMONTH, "date:strict_year_month");
        }
    };

    protected ElasticsearchMappingGenerator(ElasticsearchDriver driver, boolean hasNestedObjects) {
        this.driver = driver;
        this.hasNestedObjects = hasNestedObjects;
        this.driver.setPropertyResolver(this::getProperty);
    }

    @VisibleForTesting
    protected ElasticsearchMappingGenerator(@Nullable TypeMapping mapping, boolean hasNestedObjects, ElasticsearchDriver driver) {
        if (mapping != null) {
            this.initFields(mapping);
        }
        this.mappingInitialised = true;
        this.hasNestedObjects = hasNestedObjects;
        this.driver = driver;
    }

    public void putNewMappingsAsNeeded() throws IOException {
        this.initMapping();
        Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> mapping = this.generateNewMapping();
        if (mapping != null) {
            this.driver.putMapping(mapping);
        }
    }

    public Set<String> getExistingFields() throws IOException {
        this.initMapping();
        return this.existingFields.keySet();
    }

    public String generateFieldAsNeeded(String fieldName, @Nullable Value value, Property property) throws IOException {
        String type;
        this.initMapping();
        Object fqn = fieldName;
        Property parentProperty = property.getParentProperty();
        if (parentProperty != null) {
            String parentFqn = parentProperty.getFieldName().fullyQualifiedNameWithoutSuffix;
            fqn = parentFqn + "." + fieldName;
        }
        if ((type = this.knownFieldMappings.get(fqn)) != null) {
            return type;
        }
        return this.generateFieldAsNeededManaged(fieldName, (String)fqn, value, property, parentProperty);
    }

    public static ElasticsearchMappingGenerator getNoopInstance(ElasticsearchDriver driver, boolean hasNestedObjects) {
        return new ElasticsearchMappingGenerator(driver, hasNestedObjects){

            @Override
            public void putNewMappingsAsNeeded() {
            }

            @Override
            protected String generateFieldAsNeededManaged(String fieldName, String fqn, @Nullable Value value, Property property, @Nullable Property parentProperty) {
                if (value instanceof Literal) {
                    return "text";
                }
                return "keyword";
            }
        };
    }

    @VisibleForTesting
    protected Map<String, String> getKnownFieldMappings() {
        return this.knownFieldMappings;
    }

    private void initMapping() throws IOException {
        if (this.mappingInitialised) {
            return;
        }
        if (this.driver.indexExists()) {
            this.initFields(this.driver.getMapping());
        }
        this.mappingInitialised = true;
    }

    private void initFields(TypeMapping mapping) {
        Map properties = mapping.properties();
        if (properties != null) {
            ElasticsearchUtil.addMutableProperties(properties, this.existingFields);
            this.initKnownFields();
        }
    }

    private void initKnownFields() {
        this.initKnownFields("", this.existingFields);
    }

    private void initKnownFields(String parentName, Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> parentProperties) {
        parentProperties.forEach((field, property) -> {
            String type = property._kind().jsonValue().toLowerCase();
            String fqn = parentName + field;
            this.knownFieldMappings.put(fqn, type);
            if ("geo_point".equals(type)) {
                this.knownFieldMappings.put(fqn + ".lat", GEO_POINT_LAT_LONG_TYPE);
                this.knownFieldMappings.put(fqn + ".lon", GEO_POINT_LAT_LONG_TYPE);
            }
            if (property.isNested()) {
                this.initKnownFields(fqn + ".", property.nested().properties());
            }
        });
    }

    private co.elastic.clients.elasticsearch._types.mapping.Property getMetadataForValue(Value value, Property property) {
        Object nativeFormat;
        String type;
        String[] format = new String[]{null};
        if (property.isIndexed() && property.isAnalyzed()) {
            type = property.getNativeType();
            if (type == null) {
                if (value instanceof Literal) {
                    IRI datatype = ((Literal)value).getDatatype();
                    if (datatype != null && datatype.getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
                        type = ElasticsearchMappingGenerator.getTypeFromDatatype(datatype);
                        format[0] = ElasticsearchMappingGenerator.getFormatFromDatatype(datatype);
                    }
                } else {
                    type = "keyword";
                }
            } else if (type.equals("vector")) {
                type = Property.Kind.DenseVector.jsonValue();
            } else {
                format[0] = ElasticsearchMappingGenerator.getFormatFromDatatype(property.getXsdType());
            }
            if (type == null) {
                type = "text";
            }
        } else {
            type = "keyword";
        }
        if (format[0] == null && (nativeFormat = property.getNativeSettings().get("format")) != null) {
            format[0] = nativeFormat.toString();
        }
        return ElasticsearchUtil.buildProperty(type, property.isFielddata(), property.isIndexed(), property.isStored(), format[0], property.getAnalyzer(), this.driver.getVectorBuilder(), property.getNativeSettings());
    }

    protected String generateFieldAsNeededManaged(String fieldName, String fqn, @Nullable Value value, Property property, @Nullable Property parentProperty) throws IOException {
        Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> localExistingFields = this.existingFields;
        if (this.hasNestedObjects && parentProperty != null) {
            String parentFieldName = parentProperty.getFieldName().fullyQualifiedNameWithoutSuffix;
            if ("geo_point".equals(parentProperty.getNativeType()) && (fieldName.equals("lat") || fieldName.equals("lon"))) {
                this.generateFieldAsNeeded(parentProperty.getFieldNameWithoutSuffix(), (Value)NON_EMPTY_LITERAL, parentProperty);
                this.knownFieldMappings.put(parentFieldName + "." + fieldName, GEO_POINT_LAT_LONG_TYPE);
                return GEO_POINT_LAT_LONG_TYPE;
            }
            localExistingFields = this.generateNestedFieldAsNeeded(localExistingFields, parentFieldName, parentProperty);
        }
        this.mappingChanged = true;
        assert (value != null);
        co.elastic.clients.elasticsearch._types.mapping.Property metadata = this.getMetadataForValue(value, property);
        String type = metadata._kind().jsonValue().toLowerCase();
        this.knownFieldMappings.put(fqn, type);
        localExistingFields.put(fieldName, metadata);
        return type;
    }

    private Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> generateNestedFieldAsNeeded(Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> nestedExistingFields, String nestedFieldName, Property nestedProperty) {
        int dotPos = nestedFieldName.lastIndexOf(46);
        if (dotPos > -1) {
            nestedExistingFields = this.generateNestedFieldAsNeeded(nestedExistingFields, nestedFieldName.substring(0, dotPos), nestedProperty.getParentProperty());
            nestedFieldName = nestedFieldName.substring(dotPos + 1);
        }
        if (nestedExistingFields.containsKey(nestedFieldName)) {
            co.elastic.clients.elasticsearch._types.mapping.Property pObject = nestedExistingFields.get(nestedFieldName);
            if (!(pObject.isNested() || pObject.isObject() || pObject.isGeoPoint())) {
                throw new ClientErrorException("Bad mapping for nested object property: " + nestedFieldName);
            }
            if (!(pObject instanceof GraphDBPropertyWrapper)) {
                throw new ClientErrorException("Unmodifiable nested object property: " + nestedFieldName);
            }
            return ((GraphDBPropertyWrapper)pObject).getProperties();
        }
        String type = nestedProperty.getNativeType();
        type = type == null ? "object" : type;
        this.knownFieldMappings.put(nestedProperty.getFieldName().fullyQualifiedNameWithoutSuffix, type);
        HashMap<String, co.elastic.clients.elasticsearch._types.mapping.Property> finalExistingFields = new HashMap<String, co.elastic.clients.elasticsearch._types.mapping.Property>();
        co.elastic.clients.elasticsearch._types.mapping.Property newProp = ElasticsearchUtil.buildProperty(type, this.driver.getVectorBuilder(), finalExistingFields);
        nestedExistingFields.put(nestedFieldName, newProp);
        return finalExistingFields;
    }

    @VisibleForTesting
    protected void setMappingChanged(boolean mappingChanged) {
        this.mappingChanged = mappingChanged;
    }

    protected Map<String, co.elastic.clients.elasticsearch._types.mapping.Property> generateNewMapping() {
        if (!this.mappingChanged) {
            return null;
        }
        this.mappingChanged = false;
        return Collections.unmodifiableMap(this.existingFields);
    }

    protected static String getTypeFromDatatype(IRI datatype) {
        if (datatype.getNamespace().equals("native:")) {
            return datatype.getLocalName();
        }
        String type = XML_TYPE_TO_ELASTICSEARCH_TYPE.get(datatype);
        return type != null ? type.split(":", 2)[0] : null;
    }

    protected static String getFormatFromDatatype(IRI datatype) {
        int indexOfColon;
        String type = XML_TYPE_TO_ELASTICSEARCH_TYPE.get(datatype);
        if (type != null && (indexOfColon = type.indexOf(58)) > -1) {
            return type.substring(indexOfColon + 1);
        }
        return null;
    }

    public co.elastic.clients.elasticsearch._types.mapping.Property getProperty(String fieldName) {
        try {
            this.initMapping();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize mappings for index: " + this.driver.getIndexName(), e);
        }
        return this.existingFields.get(fieldName);
    }
}

