/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.IndexExistValidator;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchPlugin;
import com.ontotext.trree.sdk.PluginException;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ElasticsearchIndexExistValidator
implements IndexExistValidator<String> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String validate(ExternalSyncPlugin plugin, @Nullable Options optionsToUpdate, Options optionsSet) {
        String nodes = (String)optionsSet.getValue(ElasticsearchPlugin.ELASTICSEARCH_NODE);
        String indexName = optionsSet.getStoreName();
        try {
            if (optionsToUpdate == null) return null;
            if (!plugin.isTestingTransaction()) return null;
            if (!StringUtils.isNotEmpty((CharSequence)nodes)) return null;
            try (ElasticsearchDriver elasticsearchDriver = ElasticsearchDriver.from(plugin.getLogger(), indexName, optionsSet);){
                if (elasticsearchDriver.indexExists()) return null;
                String string = "The index '" + indexName + "' does not exist on the " + nodes + " 'elasticsearchNode'";
                return string;
            }
        }
        catch (IOException e2) {
            throw new PluginException("Could not close elasticsearch driver");
        }
    }

    @Nullable
    public Object validate(@Nullable String value, Options optionsSet) {
        throw new IllegalStateException("Plugin required. Use the other method to validate.");
    }
}

