/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.json.ElasticsearchUtil;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.auth.HttpClientConfigurator;
import com.ontotext.trree.plugin.externalsync.auth.UsernamePasswordProvider;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticClientSupplier;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchPlugin;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchResult;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.GraphDBBulkRequestBuilder;
import com.ontotext.trree.plugin.externalsync.impl.embedding.EmbeddingModelUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.ServerErrorException;
import dev.langchain4j.data.embedding.Embedding;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.eclipse.rdf4j.model.Value;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;

public class ElasticsearchDriver
implements HealthCheckable {
    private static final String PROPERTY_NAME_FOR_ALWAYS_REFRESH = "connectors.elasticsearch.alwaysrefresh";
    private static final String ELASTIC_CONNECTION_TIMEOUT_PROPERTY = "elastic.connection.timeout";
    private static final int ELASTIC_CONNECTION_TIMEOUT_DEFAULT = 30000;
    private static final String ELASTIC_SO_TIMEOUT_PROPERTY = "elastic.so.timeout";
    private static final int ELASTIC_SO_TIMEOUT_DEFAULT = 120000;
    private static final String SCORE_FIELD_NAME = "_score";
    private static final int MAX_RESULT_WINDOW_DEFAULT = 10000;
    private static final int ELASTICSEARCH_ID_LENGTH_LIMIT = 512;
    private final Logger logger;
    private final String indexName;
    private RestClient queryClient;
    private Sniffer sniffer;
    private ElasticsearchClient client;
    private final boolean manageIndex;
    private VectorBuilder vectorBuilder;
    private int maxResultWindow;
    private long bulkUpdateBatchSize;
    private static final boolean isAlwaysRefreshEnabled;
    private Function<String, Property> propertyResolver;
    private ExternalStore store;
    private GraphDBBulkRequestBuilder bulkRequest;
    static final ElasticClientSupplier DEFAULT_CLIENT_SUPPLIER;
    private static ElasticClientSupplier supplier;

    private ElasticsearchDriver(Logger logger, String indexName, Options options) throws UnknownHostException {
        this.logger = logger;
        this.indexName = indexName;
        this.manageIndex = (Boolean)options.getValue(ElasticsearchPlugin.MANAGE_INDEX);
        this.applyUpdatableOptions(options);
        this.beginInternal();
    }

    protected void setExternalStore(ExternalStore store) {
        this.store = store;
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public ElasticsearchResult query(MasterResultIterator mri) {
        SearchOptions searchOptions = mri.getSearchOptions();
        SearchRequest.Builder searchRequest = ElasticsearchUtil.searchBuilderWithCustomParameters(this.indexName, this.vectorBuilder, mri, this.propertyResolver);
        int numTopDocs = searchOptions.limit;
        if (numTopDocs > 0) {
            searchRequest.size(Integer.valueOf(numTopDocs));
        }
        if (mri.isTrackScore()) {
            searchRequest.trackScores(Boolean.valueOf(true));
        }
        for (SearchOptions.OrderPredicate p : searchOptions.orderBy) {
            SortOrder order;
            if (p.isScoreSpecial()) {
                order = SortOrder.Desc;
                if (p.reverse) {
                    order = SortOrder.Asc;
                }
                searchRequest.sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(SCORE_FIELD_NAME).order(order).build()).build(), new SortOptions[0]);
                continue;
            }
            order = SortOrder.Asc;
            if (p.reverse) {
                order = SortOrder.Desc;
            }
            searchRequest.sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(p.predicate).order(order).build()).build(), new SortOptions[0]);
        }
        this.addFacets(searchRequest, searchOptions.facets);
        return new ElasticsearchResult(this.indexName, this.logger, searchOptions.offset, numTopDocs, true, this.client, searchRequest, this.getMaxResultWindow());
    }

    void putMapping(Map<String, Property> mapping) throws IOException {
        if (this.store.isTestingTransaction()) {
            this.client.indices().putMapping(new PutMappingRequest.Builder().properties(mapping).index(this.indexName, new String[0]).build());
        }
    }

    private void addFacets(SearchRequest.Builder searchRequest, List<String> facets) {
        HashMap<String, Aggregation> map = new HashMap<String, Aggregation>();
        for (String facet : facets) {
            map.put(facet, AggregationBuilders.terms().field(facet).build()._toAggregation());
        }
        searchRequest.aggregations(map);
    }

    public void createIndex() {
        if (this.manageIndex && this.store.isTestingTransaction()) {
            CreateIndexRequest.Builder createIndexRequest = supplier.newCreateIndexRequest(this.indexName);
            Object settings = this.store.getOptions().getValue(ElasticsearchPlugin.CREATE_SETTINGS);
            if (settings != null) {
                IndexSettings.Builder indexSettings = new IndexSettings.Builder();
                indexSettings.otherSettings(ElasticsearchUtil.parseJson(settings));
                createIndexRequest.settings(indexSettings.build());
            }
            try {
                this.client.indices().create(createIndexRequest.build());
            }
            catch (IOException e) {
                throw new ConnectorServerException("Cannot create index", (Throwable)e);
            }
        }
    }

    protected TypeMapping getMapping() throws IOException {
        Map mappingsResponse = this.client.indices().getMapping(new GetMappingRequest.Builder().index(this.indexName, new String[0]).build()).mappings();
        if (mappingsResponse.size() > 1) {
            throw new ConnectorUserException("Mapping returned more than one record: '" + this.indexName + "' must be an index or a search alias with a single writable index");
        }
        return ((IndexMappingRecord)mappingsResponse.values().iterator().next()).mappings();
    }

    protected IndexSettings getIndexSettings() throws IOException {
        Map indexSettings = this.client.indices().getSettings(new GetIndicesSettingsRequest.Builder().index(this.indexName, new String[0]).build()).settings();
        if (indexSettings.size() > 1) {
            throw new ConnectorUserException("Settings returned more than one record: '" + this.indexName + "' must be an index or a search alias with a single writable index");
        }
        return ((IndexState)indexSettings.values().iterator().next()).settings();
    }

    protected boolean indexExists() {
        try {
            return this.client.indices().exists(new ExistsRequest.Builder().index(this.indexName, new String[0]).build()).value();
        }
        catch (IOException e) {
            throw new ConnectorServerException("Unable to check if index exists", (Throwable)e);
        }
    }

    private int getMaxResultWindow() {
        if (this.maxResultWindow == 0) {
            try {
                IndexSettings indexSettings = this.getIndexSettings().index();
                this.maxResultWindow = indexSettings.maxResultWindow() != null ? indexSettings.maxResultWindow() : 10000;
            }
            catch (IOException e) {
                throw new ConnectorServerException("Cannot get index settings.", (Throwable)e);
            }
        }
        return this.maxResultWindow;
    }

    private void beginInternal() {
        if (this.bulkRequest == null || this.bulkRequest.numberOfOperations() > 0) {
            this.bulkRequest = new GraphDBBulkRequestBuilder();
            LinkedList documentsForEmbeddings = new LinkedList();
            this.bulkRequest.bulkPreprocessor(documents -> {
                for (Map doc : documents) {
                    for (Map.Entry entry : doc.entrySet()) {
                        if (!this.isDenseVector((String)entry.getKey())) continue;
                        if (this.vectorBuilder == null) {
                            EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                        }
                        String string = entry.getValue().toString();
                        documentsForEmbeddings.add(string);
                        entry.setValue(documentsForEmbeddings.size() - 1);
                    }
                }
                if (!documentsForEmbeddings.isEmpty()) {
                    List embeddings = this.vectorBuilder.embeddingsFromTexts(documentsForEmbeddings).stream().map(Embedding::vector).collect(Collectors.toList());
                    for (Map doc : documents) {
                        for (Map.Entry entry : doc.entrySet()) {
                            if (!this.isDenseVector((String)entry.getKey())) continue;
                            int index = (Integer)entry.getValue();
                            entry.setValue(embeddings.get(index));
                        }
                    }
                }
                this.logger.info("Preprocessed {} documents for embeddings.", (Object)documents.size());
                this.logger.info("Calculated {} embeddings for them.", (Object)documentsForEmbeddings.size());
            });
        }
    }

    @VisibleForTesting
    void flushIfNeeded() {
        if ((long)this.bulkRequest.numberOfOperations() >= this.bulkUpdateBatchSize) {
            this.flush();
        }
    }

    private void flush() {
        if (this.bulkRequest.numberOfOperations() > 0) {
            if (this.shouldRefresh()) {
                this.bulkRequest.refresh(Refresh.True);
            }
            this.logger.info("[{}] Preprocessing {} documents in bulk.", (Object)this.indexName, (Object)this.bulkRequest.numberOfDocsToPreprocess());
            this.bulkRequest.preprocessDocumentsInBulk();
            this.logger.info("[{}] Sending {} bulk actions to Elasticsearch.", (Object)this.indexName, (Object)this.bulkRequest.numberOfOperations());
            try {
                BulkResponse bulkResponse = this.client.bulk(this.bulkRequest.build());
                if (bulkResponse.errors()) {
                    throw new PluginException(ElasticsearchUtil.buildFailureMessage(bulkResponse));
                }
            }
            catch (Exception e) {
                if (e instanceof PluginException) {
                    throw (PluginException)e;
                }
                throw new ConnectorServerException("Error on bulk request", (Throwable)e);
            }
            finally {
                this.beginInternal();
            }
        }
    }

    void rollback(Entities entities) {
        TreeSet entitiesToRefresh;
        if (this.store.isTestingTransaction() && (entitiesToRefresh = this.store.getEntitiesToRefresh()) != null) {
            this.beginInternal();
            for (Long subject : entitiesToRefresh) {
                Value value = entities.get(subject.longValue());
                if (value != null) {
                    this.delete(EntitiesUtil.valueToString((Value)value));
                    continue;
                }
                this.logger.warn("[{}] Value not found in entity pool. This is probably a bug.", (Object)this.store.getName());
            }
            this.flush();
        }
    }

    void commit() {
        this.flush();
    }

    static void setSupplier(ElasticClientSupplier supplier) {
        ElasticsearchDriver.supplier = supplier;
    }

    private boolean isTestMode() {
        return supplier != DEFAULT_CLIENT_SUPPLIER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String canConnectToElasticsearch(Options options, Logger logger) {
        try (RestClient tmpClient = supplier.createClient(null, null, options, logger);){
            String string;
            try (RestClientTransport elasticsearchTransport = new RestClientTransport(tmpClient, (JsonpMapper)new JacksonJsonpMapper());){
                ElasticsearchClient pingClient = new ElasticsearchClient((ElasticsearchTransport)elasticsearchTransport);
                pingClient.ping();
                string = null;
            }
            return string;
        }
        catch (Exception ex) {
            return ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
        }
    }

    public static ElasticsearchDriver from(Logger logger, String storeName, Options options) {
        try {
            return new ElasticsearchDriver(logger, storeName, options);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    void delete(String uri) {
        if (this.store.isTestingTransaction()) {
            DeleteOperation delete = ((DeleteOperation.Builder)((DeleteOperation.Builder)new DeleteOperation.Builder().index(this.indexName)).id(uri)).build();
            this.bulkRequest.viewableOperations((BulkOperation)new BulkOperation.Builder().delete(delete).build(), new BulkOperation[0]);
            this.flushIfNeeded();
        }
    }

    void deleteAll() {
        if (this.store.isTestingTransaction()) {
            try {
                DeleteByQueryRequest.Builder request = new DeleteByQueryRequest.Builder().index(this.indexName, new String[0]).query(new MatchAllQuery.Builder().build()._toQuery());
                if (this.shouldRefresh()) {
                    request.refresh(Boolean.valueOf(true));
                }
                this.client.deleteByQuery(request.build());
            }
            catch (IOException e) {
                throw new ServerErrorException("Unable to delete documents from Elasticsearch on repository clear", (Throwable)e);
            }
        }
    }

    public void index(Map<String, Object> content, String uri) {
        if (this.store.isTestingTransaction()) {
            if (uri.length() <= 512) {
                GraphDBBulkRequestBuilder bulkRequestBuilder = this.bulkRequest.viewableOperations((BulkOperation)new BulkOperation.Builder().index(supplier.newIndexOperation(content, uri, this.indexName)).build(), new BulkOperation[0]);
                if (this.documentHasVectorFields(content)) {
                    bulkRequestBuilder.preprocessDocument(content);
                }
                this.flushIfNeeded();
            } else {
                this.logger.warn("[{}] Skipping document with id longer than {} characters (Elasticsearch limitation): {}", new Object[]{this.indexName, 512, uri});
            }
        }
    }

    private boolean documentHasVectorFields(Map<String, Object> content) {
        for (String key : content.keySet()) {
            if (!this.isDenseVector(key)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldRefresh() {
        return this.isTestMode() || isAlwaysRefreshEnabled;
    }

    public void dropIndex() {
        if (this.manageIndex && this.store.isTestingTransaction()) {
            try {
                this.client.indices().delete(new DeleteIndexRequest.Builder().index(this.indexName, new String[0]).build());
            }
            catch (IOException e) {
                throw new ConnectorServerException("Error dropping index", (Throwable)e);
            }
        }
    }

    void close() throws IOException {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error closing sniffer (ignored)", (Throwable)e);
        }
        this.queryClient.close();
        if (this.vectorBuilder != null && this.vectorBuilder.getEmbeddingModel() instanceof Closeable) {
            try {
                ((Closeable)this.vectorBuilder.getEmbeddingModel()).close();
            }
            catch (Exception e) {
                this.logger.warn("Error closing embedding model (ignored)", (Throwable)e);
            }
        }
    }

    public HealthResult runHealthCheck() {
        try {
            SearchRequest searchRequest = new SearchRequest.Builder().index(this.indexName, new String[0]).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).size(Integer.valueOf(1)).build();
            SearchResponse searchResponse = this.client.search(searchRequest, Object.class);
            String message = String.format("query took %d ms, %d hits, %d failed shards", searchResponse.took(), searchResponse.hits().total() != null ? searchResponse.hits().total().value() : 0L, searchResponse.shards().failed().longValue());
            if (searchResponse.shards().failed().longValue() > 0L || searchResponse.hits().total() == null || searchResponse.hits().total().value() == 0L) {
                return new HealthResult(this.indexName, HealthResult.Status.YELLOW, message);
            }
            return new HealthResult(this.indexName, HealthResult.Status.GREEN, message);
        }
        catch (Exception e) {
            return new HealthResult(this.indexName, HealthResult.Status.RED, "query cannot be run: " + e.getMessage());
        }
    }

    void applyUpdatableOptions(Options options) throws UnknownHostException {
        boolean clusterSniff = (Boolean)options.getValue(ElasticsearchPlugin.ELASTICSEARCH_CLUSTER_SNIFF);
        SniffOnFailureListener snifferListener = null;
        if (clusterSniff) {
            snifferListener = new SniffOnFailureListener();
        }
        RestClient newQueryClient = supplier.createClient(this, snifferListener, options, this.logger);
        Sniffer newSniffer = null;
        if (clusterSniff) {
            newSniffer = supplier.createSniffer(newQueryClient, supplier.getDefaultScheme(options));
            snifferListener.setSniffer(newSniffer);
        }
        RestClient oldQueryClient = this.queryClient;
        Sniffer oldSniffer = this.sniffer;
        this.queryClient = newQueryClient;
        this.sniffer = newSniffer;
        this.client = new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(this.queryClient, (JsonpMapper)new JacksonJsonpMapper()));
        this.bulkUpdateBatchSize = (Long)options.getValue(ElasticsearchPlugin.BULK_UPDATE_BATCH_SIZE);
        VectorBuilder oldVectorBuilder = this.vectorBuilder;
        String embeddingModel = (String)options.getValue(ElasticsearchPlugin.EMBEDDING_MODEL);
        VectorBuilder vectorBuilder = this.vectorBuilder = embeddingModel != null && !embeddingModel.isEmpty() ? new VectorBuilder(EmbeddingModelUtil.createInstance((String)embeddingModel)) : null;
        if (oldSniffer != null) {
            oldSniffer.close();
        }
        if (oldQueryClient != null) {
            try {
                oldQueryClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (oldVectorBuilder != null && oldVectorBuilder.getEmbeddingModel() instanceof Closeable) {
            try {
                ((Closeable)oldVectorBuilder.getEmbeddingModel()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isDenseVector(String propertyName) {
        if (this.propertyResolver != null) {
            Property property = this.propertyResolver.apply(propertyName);
            return property != null && property._kind() == Property.Kind.DenseVector;
        }
        return false;
    }

    public void setPropertyResolver(Function<String, Property> propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public VectorBuilder getVectorBuilder() {
        return this.vectorBuilder;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$static$3(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    static {
        String property = System.getProperty(PROPERTY_NAME_FOR_ALWAYS_REFRESH);
        isAlwaysRefreshEnabled = Boolean.parseBoolean(property);
        supplier = DEFAULT_CLIENT_SUPPLIER = (driver, sniffer, options, logger) -> {
            String nodes = (String)options.getValue(ElasticsearchPlugin.ELASTICSEARCH_NODE);
            assert (nodes != null);
            String[] nodesSplit = nodes.split("[,;\\s]+");
            HttpHost[] serverAddresses = new HttpHost[nodesSplit.length];
            for (int i = 0; i < nodesSplit.length; ++i) {
                serverAddresses[i] = HttpHost.create((String)nodesSplit[i]);
            }
            if (serverAddresses.length == 0) {
                throw new ConnectorUserException("At least one Elasticsearch node must be provided.");
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])serverAddresses);
            String username = null;
            String password = null;
            Object authenticationProvider = OptionsUtil.instantiateClassFromOption((Options)options, ElasticsearchPlugin.AUTHENTICATION_CONFIGURATOR_CLASS);
            RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback = httpClientBuilder -> httpClientBuilder;
            if (authenticationProvider != null) {
                String storeName = options.getStoreName();
                if (authenticationProvider instanceof HttpClientConfigurator) {
                    httpClientConfigCallback = httpAsyncClientBuilder -> {
                        CredentialsProvider credentialsProvider;
                        HttpClientConfigurator httpClientConfigurator = (HttpClientConfigurator)authenticationProvider;
                        HttpRequestInterceptor authInterceptor = httpClientConfigurator.getHttpRequestInterceptor(nodes, storeName);
                        if (authInterceptor != null) {
                            httpAsyncClientBuilder.addInterceptorLast(authInterceptor);
                        }
                        if ((credentialsProvider = httpClientConfigurator.getCredentialsProvider(nodes, storeName)) != null) {
                            httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                        }
                        if (httpClientConfigurator.shouldDisableAuthCaching(nodes, storeName)) {
                            httpAsyncClientBuilder.disableAuthCaching();
                        }
                        return httpAsyncClientBuilder;
                    };
                } else {
                    if (!(authenticationProvider instanceof UsernamePasswordProvider)) throw new ConnectorUserException("Provided authentication class " + authenticationProvider.getClass().getName() + " does not implement any of the supported interfaces");
                    UsernamePasswordProvider.Credentials credentials = ((UsernamePasswordProvider)authenticationProvider).getCredentials(nodes, storeName);
                    if (credentials != null) {
                        username = credentials.getUsername();
                        password = credentials.getPassword();
                    }
                }
            } else {
                username = (String)options.getValue(ElasticsearchPlugin.BASIC_AUTH_USER);
                password = (String)options.getValue(ElasticsearchPlugin.BASIC_AUTH_PASSWORD);
            }
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientConfigCallback = arg_0 -> ElasticsearchDriver.lambda$static$3((CredentialsProvider)credentialsProvider, arg_0);
            }
            builder.setHttpClientConfigCallback(httpClientConfigCallback);
            builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(Config.getPropertyAsInt((String)ELASTIC_CONNECTION_TIMEOUT_PROPERTY, (int)30000)).setSocketTimeout(Config.getPropertyAsInt((String)ELASTIC_SO_TIMEOUT_PROPERTY, (int)120000)));
            if (sniffer == null) return builder.build();
            builder.setFailureListener((RestClient.FailureListener)sniffer);
            return builder.build();
        };
    }
}

