/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.KnnSearch;
import co.elastic.clients.elasticsearch._types.mapping.AggregateMetricDoubleProperty;
import co.elastic.clients.elasticsearch._types.mapping.BinaryProperty;
import co.elastic.clients.elasticsearch._types.mapping.BooleanProperty;
import co.elastic.clients.elasticsearch._types.mapping.ByteNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.CompletionProperty;
import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.DateNanosProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorProperty;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorSimilarity;
import co.elastic.clients.elasticsearch._types.mapping.DoubleNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.DoubleRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.DynamicProperty;
import co.elastic.clients.elasticsearch._types.mapping.FieldAliasProperty;
import co.elastic.clients.elasticsearch._types.mapping.FlattenedProperty;
import co.elastic.clients.elasticsearch._types.mapping.FloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.FloatRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoPointProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.HalfFloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.HistogramProperty;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.IntegerNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.IntegerRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.JoinProperty;
import co.elastic.clients.elasticsearch._types.mapping.KeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.LongNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.LongRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.MatchOnlyTextProperty;
import co.elastic.clients.elasticsearch._types.mapping.Murmur3HashProperty;
import co.elastic.clients.elasticsearch._types.mapping.NestedProperty;
import co.elastic.clients.elasticsearch._types.mapping.ObjectProperty;
import co.elastic.clients.elasticsearch._types.mapping.PercolatorProperty;
import co.elastic.clients.elasticsearch._types.mapping.PointProperty;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.RankFeatureProperty;
import co.elastic.clients.elasticsearch._types.mapping.RankFeaturesProperty;
import co.elastic.clients.elasticsearch._types.mapping.ScaledFloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.SearchAsYouTypeProperty;
import co.elastic.clients.elasticsearch._types.mapping.SemanticTextProperty;
import co.elastic.clients.elasticsearch._types.mapping.ShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.ShortNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.TextIndexPrefixes;
import co.elastic.clients.elasticsearch._types.mapping.TextProperty;
import co.elastic.clients.elasticsearch._types.mapping.TokenCountProperty;
import co.elastic.clients.elasticsearch._types.mapping.UnsignedLongNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.VersionProperty;
import co.elastic.clients.elasticsearch._types.mapping.WildcardProperty;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SemanticQuery;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.QueryHighlighter;
import co.elastic.clients.json.ToStringMapper;
import co.elastic.clients.util.NamedValue;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.GraphDBPropertyWrapper;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util.GraphDBSearchRequestBuilder;
import com.ontotext.trree.plugin.externalsync.impl.embedding.EmbeddingModelUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.StatisticsUtil;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Repository;
import dev.langchain4j.data.embedding.Embedding;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Value;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchUtil {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchUtil.class);
    private static final Map<String, Property.Kind> PROPERTY_KIND_MAP = new HashMap<String, Property.Kind>();
    private static final String COERCE = "coerce";
    private static final String COPY_TO = "copy_to";
    private static final String DOC_VALUES = "doc_values";
    private static final String EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    private static final String ENABLED = "enabled";
    private static final String IGNORE_ABOVE = "ignore_above";
    private static final String IGNORE_MALFORMED = "ignore_malformed";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_PHRASES = "index_phrases";
    private static final String INDEX_PREFIXES = "index_prefixes";
    private static final String META = "meta";
    private static final String NORMALIZER = "normalizer";
    private static final String NORMS = "norms";
    private static final String POSITION_INCREMENT_GAP = "position_increment_gap";
    private static final String SEARCH_ANALYZER = "search_analyzer";
    private static final String SIMILARITY = "similarity";
    private static final String ELASTICSEARCH_CONNECTOR_NAME = "elasticsearch-connector";

    private ElasticsearchUtil() {
    }

    public static SearchRequest.Builder searchBuilderWithCustomParameters(String indexName, VectorBuilder vectorBuilder, MasterResultIterator mri, Function<String, Property> propertyResolver) {
        GraphDBSearchRequestBuilder searchBuilder = new GraphDBSearchRequestBuilder(vectorBuilder);
        searchBuilder.index(indexName, new String[0]);
        Highlight highlight = null;
        Query query = null;
        boolean useSubjectFilter = true;
        boolean useMriTrackHits = true;
        SearchOptions searchOptions = mri.getSearchOptions();
        if (mri.isSnippets()) {
            highlight = ElasticsearchUtil.buildHighlight(searchOptions);
            searchBuilder.highlight(highlight);
        }
        String queryString = mri.getQueryString();
        String similarityQueryString = mri.getSimilarityQueryString();
        if (StringUtils.isEmpty((CharSequence)queryString) && StringUtils.isEmpty((CharSequence)similarityQueryString)) {
            query = QueryBuilders.matchAll().build()._toQuery();
        }
        if (!StringUtils.isEmpty((CharSequence)queryString)) {
            if ((queryString = queryString.trim()).startsWith("{")) {
                Integer offset;
                SearchRequest parsedRequest = ((SearchRequest.Builder)searchBuilder.withJson(new StringReader(queryString))).build();
                useSubjectFilter = parsedRequest.postFilter() == null;
                useMriTrackHits = parsedRequest.trackTotalHits() == null;
                Integer size = parsedRequest.size();
                if (size != null) {
                    searchOptions.setLimit(size.toString());
                }
                if ((offset = parsedRequest.from()) != null) {
                    searchOptions.setOffset(offset.toString());
                }
                searchBuilder.size(null);
                searchBuilder.from(null);
                if (highlight != null && !ElasticsearchUtil.hasNestedHighlighter(parsedRequest.query())) {
                    QueryHighlighter highlighter = new QueryHighlighter(highlight);
                    query = highlighter.withJson(queryString);
                } else {
                    query = parsedRequest.query();
                }
            } else {
                query = QueryBuilders.queryString().query(queryString).build()._toQuery();
            }
        }
        if (query != null) {
            searchBuilder.query(query);
        }
        if (!StringUtils.isEmpty((CharSequence)similarityQueryString)) {
            String[] similarityQueryParts = similarityQueryString.trim().split(":", 2);
            if (similarityQueryParts.length != 2) {
                throw new ConnectorUserException("Invalid similarity query format. Expected format: <field>:<text>");
            }
            Property field = propertyResolver.apply(similarityQueryParts[0]);
            if (field == null) {
                throw new ConnectorUserException("Field '" + similarityQueryParts[0] + "' not configured for index " + indexName + ".");
            }
            if (field._kind() == Property.Kind.SemanticText) {
                SemanticQuery semanticQuery = new SemanticQuery.Builder().field(similarityQueryParts[0]).query(similarityQueryParts[1]).build();
                Query finalQuery = query;
                if (finalQuery == null) {
                    searchBuilder.query((QueryVariant)semanticQuery);
                } else {
                    searchBuilder.query(Query.of(q -> q.bool(b -> b.should(finalQuery, new Query[]{semanticQuery._toQuery()}))));
                }
            } else {
                if (vectorBuilder == null) {
                    EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                }
                Embedding embedding = vectorBuilder.embeddingFromText(similarityQueryParts[1]);
                KnnSearch knnSearchQuery = new KnnSearch.Builder().field(similarityQueryParts[0]).queryVector(embedding.vectorAsList()).build();
                searchBuilder.knn(knnSearchQuery, new KnnSearch[0]);
            }
        }
        ElasticsearchUtil.incrementVectorQueryStatistics(searchBuilder.build(), mri.getPluginConnection());
        searchBuilder.source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build());
        if (useSubjectFilter) {
            ElasticsearchUtil.setSubjectFilter(searchBuilder, mri);
        }
        if (mri.isTrackTotalHits() && useMriTrackHits) {
            searchBuilder.trackTotalHits((TrackHits)new TrackHits.Builder().enabled(Boolean.valueOf(true)).build());
        }
        return searchBuilder;
    }

    private static void incrementVectorQueryStatistics(SearchRequest searchRequest, PluginConnection pluginConnection) {
        Query query;
        Consumer vectorQueryRecorder = StatisticsUtil.vectorQueryRecorderFor((Repository)pluginConnection.getRepository());
        if (vectorQueryRecorder == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)searchRequest.knn())) {
            vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
        }
        if ((query = searchRequest.query()) != null) {
            if (query._kind() == Query.Kind.Semantic) {
                vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
            }
            if (query._kind() == Query.Kind.Bool) {
                BoolQuery boolQuery = (BoolQuery)query._get();
                if (boolQuery.should().stream().anyMatch(q -> q.isSemantic() || q.isKnn())) {
                    vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.must().stream().anyMatch(q -> q.isSemantic() || q.isKnn())) {
                    vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.filter().stream().anyMatch(q -> q.isSemantic() || q.isKnn())) {
                    vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.mustNot().stream().anyMatch(q -> q.isSemantic() || q.isKnn())) {
                    vectorQueryRecorder.accept(ELASTICSEARCH_CONNECTOR_NAME);
                }
            }
        }
    }

    public static <T> T handleElasticsearchException(String message, Exception e) {
        String specificMessage = null;
        if (e instanceof ElasticsearchException) {
            try {
                ElasticsearchException elasticException = (ElasticsearchException)e;
                List rootCause = elasticException.response().error().rootCause();
                if (rootCause != null && !rootCause.isEmpty()) {
                    specificMessage = ((ErrorCause)rootCause.get(0)).toString();
                }
            }
            catch (Exception ex) {
                logger.error("Could not parse error response from ES due to: ", (Throwable)ex);
            }
        }
        if (specificMessage == null) {
            specificMessage = e.getMessage();
        }
        throw new ConnectorServerException(message + ": " + specificMessage, (Throwable)e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, JsonData> parseJson(@Nullable Object json) {
        HashMap<String, JsonData> jsonDataMap = new HashMap<String, JsonData>();
        if (json instanceof Map) {
            ElasticsearchUtil.convertJSONDataIntoMap(json, jsonDataMap);
            return jsonDataMap;
        } else if (json instanceof String) {
            try {
                Object parsedJson = new JSONParser().parse((String)json);
                if (!(parsedJson instanceof Map)) return jsonDataMap;
                ElasticsearchUtil.convertJSONDataIntoMap(parsedJson, jsonDataMap);
                return jsonDataMap;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Not a valid JSON string");
            }
        } else {
            if (json != null) throw new IllegalArgumentException("Not a JSON object");
            return Collections.emptyMap();
        }
    }

    public static String parseAsJson(JsonpSerializable value) {
        return JsonpUtils.toString((JsonpSerializable)value, (JsonpMapper)ToStringMapper.INSTANCE, (StringBuilder)new StringBuilder()).toString();
    }

    public static String buildFailureMessage(BulkResponse response) {
        List responses = response.items();
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < responses.size(); ++i) {
            BulkResponseItem tmp = (BulkResponseItem)responses.get(i);
            if (tmp.error() == null) continue;
            sb.append("\n[").append(i).append("]: index [").append(tmp.index()).append("], type [").append(tmp.operationType()).append("], id [").append(tmp.id()).append("], message [").append(tmp.error()).append("]");
        }
        return sb.toString();
    }

    public static void addMutableProperties(Map<String, Property> source, Map<String, Property> destination) {
        for (Map.Entry<String, Property> entry : source.entrySet()) {
            Property prop = entry.getValue();
            if ((prop.isNested() || prop.isObject() || prop.isGeoPoint()) && !(prop instanceof GraphDBPropertyWrapper)) {
                HashMap<String, Property> newMap = new HashMap<String, Property>();
                if (prop.isNested()) {
                    NestedProperty nested = prop.nested();
                    ElasticsearchUtil.addMutableProperties(nested.properties(), newMap);
                    destination.put(entry.getKey(), ElasticsearchUtil.buildNestedProperty(newMap));
                    continue;
                }
                if (prop.isObject()) {
                    ObjectProperty obj = prop.object();
                    ElasticsearchUtil.addMutableProperties(obj.properties(), newMap);
                    destination.put(entry.getKey(), ElasticsearchUtil.buildObjectProperty(newMap));
                    continue;
                }
                GeoPointProperty geo = prop.geoPoint();
                ElasticsearchUtil.addMutableProperties(geo.properties(), newMap);
                destination.put(entry.getKey(), ElasticsearchUtil.buildGeopointProperty(newMap, null, Collections.emptyMap()));
                continue;
            }
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public static Property buildProperty(String type, VectorBuilder vectorBuilder, Map<String, Property> properties) {
        return ElasticsearchUtil.buildProperty(type, false, null, null, null, null, vectorBuilder, properties, Collections.emptyMap());
    }

    public static Property buildProperty(String type, boolean fielddata, boolean index, boolean stored, String format, String analyzer, VectorBuilder vectorBuilder, Map<String, ?> nativeSettings) {
        return ElasticsearchUtil.buildProperty(type, fielddata, index, stored, format, analyzer, vectorBuilder, null, nativeSettings);
    }

    private static Property buildProperty(String type, boolean fielddata, Boolean index, Boolean stored, String format, String analyzer, VectorBuilder vectorBuilder, Map<String, Property> properties, Map<String, ?> nativeSettings) {
        Property.Kind kind = PROPERTY_KIND_MAP.get(type);
        if (kind == null) {
            kind = Property.Kind._Custom;
        }
        switch (kind) {
            case AggregateMetricDouble: {
                AggregateMetricDoubleProperty.Builder builder = new AggregateMetricDoubleProperty.Builder();
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Binary: {
                BinaryProperty.Builder builder = new BinaryProperty.Builder();
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Boolean: {
                BooleanProperty.Builder builder = (BooleanProperty.Builder)new BooleanProperty.Builder().index(index).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Byte: {
                ByteNumberProperty.Builder builder = (ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)new ByteNumberProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE))).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Completion: {
                CompletionProperty.Builder builder = new CompletionProperty.Builder().analyzer(analyzer);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case DateNanos: {
                DateNanosProperty.Builder builder = ((DateNanosProperty.Builder)new DateNanosProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Date: {
                DateProperty.Builder builder = ((DateProperty.Builder)new DateProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case DateRange: {
                DateRangeProperty.Builder builder = ((DateRangeProperty.Builder)((DateRangeProperty.Builder)((DateRangeProperty.Builder)new DateRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE))).format(format);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case DenseVector: {
                DenseVectorProperty.Builder builder = new DenseVectorProperty.Builder().index(index);
                Object similarity = nativeSettings.get(SIMILARITY);
                if (similarity != null) {
                    builder.similarity(DenseVectorSimilarity.valueOf((String)((String)similarity)));
                }
                if (!nativeSettings.containsKey("dims")) {
                    if (vectorBuilder == null) {
                        EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                    }
                    builder.dims(Integer.valueOf(vectorBuilder.embeddingModelDimension()));
                } else {
                    builder.dims(Integer.valueOf((Integer)nativeSettings.get("dims")));
                }
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Double: {
                DoubleNumberProperty.Builder builder = (DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)new DoubleNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case DoubleRange: {
                DoubleRangeProperty.Builder builder = (DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)new DoubleRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case DynamicType: {
                DynamicProperty.Builder builder = ((DynamicProperty.Builder)new DynamicProperty.Builder().index(index).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).format(format).coerce((Boolean)nativeSettings.get(COERCE)).analyzer(analyzer);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                return builder.build()._toProperty();
            }
            case Alias: {
                FieldAliasProperty.Builder builder = new FieldAliasProperty.Builder();
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Flattened: {
                FlattenedProperty.Builder builder = new FlattenedProperty.Builder().index(index).docValues((Boolean)nativeSettings.get(DOC_VALUES)).similarity((String)nativeSettings.get(SIMILARITY)).eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Float: {
                FloatNumberProperty.Builder builder = (FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)new FloatNumberProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case FloatRange: {
                FloatRangeProperty.Builder builder = (FloatRangeProperty.Builder)((FloatRangeProperty.Builder)((FloatRangeProperty.Builder)new FloatRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case GeoPoint: {
                return ElasticsearchUtil.buildGeopointProperty(properties, stored, nativeSettings);
            }
            case GeoShape: {
                GeoShapeProperty.Builder builder = (GeoShapeProperty.Builder)new GeoShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).coerce((Boolean)nativeSettings.get(COERCE)).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case HalfFloat: {
                HalfFloatNumberProperty.Builder builder = (HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)new HalfFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Histogram: {
                HistogramProperty.Builder builder = new HistogramProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Integer: {
                IntegerNumberProperty.Builder builder = (IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)new IntegerNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case IntegerRange: {
                IntegerRangeProperty.Builder builder = (IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)new IntegerRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Ip: {
                IpProperty.Builder builder = (IpProperty.Builder)new IpProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).index(index).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case IpRange: {
                IpRangeProperty.Builder builder = (IpRangeProperty.Builder)((IpRangeProperty.Builder)((IpRangeProperty.Builder)new IpRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Join: {
                JoinProperty.Builder builder = new JoinProperty.Builder().eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Keyword: {
                KeywordProperty.Builder builder = (KeywordProperty.Builder)new KeywordProperty.Builder().index(index).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                Object similarity = nativeSettings.get(SIMILARITY);
                if (similarity != null) {
                    builder.similarity((String)similarity);
                }
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                if (nativeSettings.get(INDEX_OPTIONS) != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get(INDEX_OPTIONS))));
                }
                builder.normalizer((String)nativeSettings.get(NORMALIZER));
                builder.norms((Boolean)nativeSettings.get(NORMS));
                return builder.build()._toProperty();
            }
            case Long: {
                LongNumberProperty.Builder builder = (LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)new LongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case LongRange: {
                LongRangeProperty.Builder builder = (LongRangeProperty.Builder)((LongRangeProperty.Builder)((LongRangeProperty.Builder)new LongRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get(COERCE))).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case MatchOnlyText: {
                MatchOnlyTextProperty.Builder builder = new MatchOnlyTextProperty.Builder();
                Object copyTo = nativeSettings.get(COPY_TO);
                if (copyTo != null) {
                    if (copyTo instanceof List) {
                        builder.copyTo((List)copyTo);
                    } else {
                        builder.copyTo((String)copyTo, new String[0]);
                    }
                }
                return builder.build()._toProperty();
            }
            case Murmur3: {
                Murmur3HashProperty.Builder builder = (Murmur3HashProperty.Builder)new Murmur3HashProperty.Builder().store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Nested: {
                return ElasticsearchUtil.buildNestedProperty(properties);
            }
            case Object: {
                return ElasticsearchUtil.buildObjectProperty(properties, nativeSettings);
            }
            case Percolator: {
                PercolatorProperty.Builder builder = new PercolatorProperty.Builder();
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Point: {
                PointProperty.Builder builder = (PointProperty.Builder)new PointProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case RankFeature: {
                RankFeatureProperty.Builder builder = new RankFeatureProperty.Builder();
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case RankFeatures: {
                RankFeaturesProperty.Builder builder = new RankFeaturesProperty.Builder();
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case ScaledFloat: {
                ScaledFloatNumberProperty.Builder builder = (ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)new ScaledFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                builder.scalingFactor(Double.valueOf(nativeSettings.get("scaling_factor").toString()));
                return builder.build()._toProperty();
            }
            case SearchAsYouType: {
                SearchAsYouTypeProperty.Builder builder = ((SearchAsYouTypeProperty.Builder)new SearchAsYouTypeProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                Object similarity = nativeSettings.get(SIMILARITY);
                if (similarity != null) {
                    builder.similarity((String)similarity);
                }
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case SemanticText: {
                SemanticTextProperty.Builder builder = new SemanticTextProperty.Builder();
                ElasticsearchUtil.addInferenceAndMetaFromNativeSettings(builder, nativeSettings);
                return builder.build()._toProperty();
            }
            case Shape: {
                ShapeProperty.Builder builder = (ShapeProperty.Builder)new ShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED)).coerce((Boolean)nativeSettings.get(COERCE)).store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Short: {
                ShortNumberProperty.Builder builder = (ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)new ShortNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Text: {
                TextProperty.Builder builder = ((TextProperty.Builder)new TextProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                if (fielddata) {
                    builder.fielddata(Boolean.valueOf(true));
                }
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                Object similarity = nativeSettings.get(SIMILARITY);
                if (similarity != null) {
                    builder.similarity((String)similarity);
                }
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.indexPhrases((Boolean)nativeSettings.get(INDEX_PHRASES));
                Object prefixes = nativeSettings.get(INDEX_PREFIXES);
                if (prefixes != null) {
                    TextIndexPrefixes.Builder prefBuilder = new TextIndexPrefixes.Builder();
                    Map prefMap = (Map)prefixes;
                    if (prefMap.containsKey("max_chars")) {
                        prefBuilder.maxChars(((Integer)prefMap.get("max_chars")).intValue());
                    }
                    if (prefMap.containsKey("min_chars")) {
                        prefBuilder.minChars(((Integer)prefMap.get("min_chars")).intValue());
                    }
                    builder.indexPrefixes(prefBuilder.build());
                }
                builder.searchAnalyzer((String)nativeSettings.get(SEARCH_ANALYZER));
                builder.positionIncrementGap((Integer)nativeSettings.get(POSITION_INCREMENT_GAP));
                builder.norms((Boolean)nativeSettings.get(NORMS));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get(EAGER_GLOBAL_ORDINALS));
                if (nativeSettings.get(INDEX_OPTIONS) != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get(INDEX_OPTIONS))));
                }
                return builder.build()._toProperty();
            }
            case TokenCount: {
                TokenCountProperty.Builder builder = ((TokenCountProperty.Builder)new TokenCountProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case UnsignedLong: {
                UnsignedLongNumberProperty.Builder builder = (UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)new UnsignedLongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED))).coerce((Boolean)nativeSettings.get(COERCE));
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Version: {
                VersionProperty.Builder builder = (VersionProperty.Builder)new VersionProperty.Builder().store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
            case Wildcard: {
                WildcardProperty.Builder builder = (WildcardProperty.Builder)new WildcardProperty.Builder().store(stored);
                ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
                ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
                return builder.build()._toProperty();
            }
        }
        throw new IllegalArgumentException("Unknown property type " + type);
    }

    private static void setSubjectFilter(SearchRequest.Builder searchRequest, MasterResultIterator mri) {
        if (mri.getEntitySubjectFilter() != 0L) {
            IdsQuery queryBuilder = QueryBuilders.ids().values(EntitiesUtil.valueToString((Value)mri.getEntities().get(mri.getEntitySubjectFilter())), new String[0]).build();
            searchRequest.postFilter(queryBuilder._toQuery());
        }
    }

    private static Highlight buildHighlight(SearchOptions searchOptions) {
        Highlight.Builder highlightBuilder = new Highlight.Builder();
        highlightBuilder.fields(List.of(new NamedValue("*", (Object)new HighlightField.Builder().matchedFields("*", new String[0]).build())));
        highlightBuilder.preTags(searchOptions.snippetPre, new String[0]);
        highlightBuilder.postTags(searchOptions.snippetPost, new String[0]);
        if (searchOptions.snippetSize > 0) {
            highlightBuilder.fragmentSize(Integer.valueOf(searchOptions.snippetSize));
        }
        return highlightBuilder.build();
    }

    private static boolean hasNestedHighlighter(Query query) {
        if (query == null) {
            return true;
        }
        boolean result = false;
        if (query.isNested()) {
            InnerHits hits = query.nested().innerHits();
            if (hits != null) {
                result = hits.highlight() != null;
            }
        } else if (query.isBool()) {
            for (Query q : query.bool().should()) {
                result |= ElasticsearchUtil.hasNestedHighlighter(q);
            }
            if (!result) {
                for (Query q : query.bool().must()) {
                    result |= ElasticsearchUtil.hasNestedHighlighter(q);
                }
            }
        }
        return result;
    }

    private static <U extends CorePropertyBase.AbstractBuilder> void addCopyToProperty(U builder, Map<String, ?> nativeSettings) {
        Object copyTo = nativeSettings.get(COPY_TO);
        if (copyTo != null) {
            if (copyTo instanceof List) {
                builder.copyTo((List)copyTo);
            } else {
                builder.copyTo((String)copyTo, new String[0]);
            }
        }
    }

    private static <U extends PropertyBase.AbstractBuilder> void addIgnoreAboveAndMetaToProperty(U builder, Map<String, ?> nativeSettings) {
        builder.ignoreAbove((Integer)nativeSettings.get(IGNORE_ABOVE));
        Object meta = nativeSettings.get(META);
        if (meta != null) {
            builder.meta((Map)meta);
        }
    }

    private static void addInferenceAndMetaFromNativeSettings(SemanticTextProperty.Builder builder, Map<String, ?> nativeSettings) {
        Object searchInferenceId;
        Object inferenceId;
        Object meta = nativeSettings.get(META);
        if (meta != null) {
            builder.meta((Map)meta);
        }
        if ((inferenceId = nativeSettings.get("inference_id")) != null) {
            builder.inferenceId((String)inferenceId);
        }
        if ((searchInferenceId = nativeSettings.get("search_inference_id")) != null && !searchInferenceId.equals(inferenceId)) {
            builder.searchInferenceId((String)searchInferenceId);
        }
    }

    private static Property buildNestedProperty(Map<String, Property> properties) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        NestedProperty.Builder builder = (NestedProperty.Builder)new NestedProperty.Builder().properties(properties);
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildGeopointProperty(Map<String, Property> properties, Boolean stored, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        GeoPointProperty.Builder builder = new GeoPointProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
        builder.store(stored);
        ElasticsearchUtil.addCopyToProperty(builder, nativeSettings);
        ElasticsearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
        builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildObjectProperty(Map<String, Property> properties) {
        return ElasticsearchUtil.buildObjectProperty(properties, Collections.emptyMap());
    }

    private static Property buildObjectProperty(Map<String, Property> properties, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        ObjectProperty.Builder builder = ((ObjectProperty.Builder)new ObjectProperty.Builder().properties(properties)).enabled((Boolean)nativeSettings.get(ENABLED));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static void convertJSONDataIntoMap(Object json, HashMap<String, JsonData> jsonDataMap) {
        for (Map.Entry entry : ((Map)json).entrySet()) {
            Object value = entry.getValue();
            jsonDataMap.put((String)entry.getKey(), value instanceof Map ? JsonData.fromJson((String)value.toString()) : JsonData.of((Object)value.toString()));
        }
    }

    static {
        for (Property.Kind type : Property.Kind.values()) {
            PROPERTY_KIND_MAP.put(type.jsonValue(), type);
        }
    }
}

