/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.txrollback;

import com.ontotext.graphdb.plugin.txrollback.TxRollbackException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.UpdateInterpreter;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class TxRollbackPlugin
extends PluginBase
implements UpdateInterpreter,
StatelessPlugin {
    private static IRI rollbackIri = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/rollback");
    private long abortId;

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        this.abortId = pluginConnection.getEntities().put((Value)rollbackIri, Entities.Scope.SYSTEM);
    }

    public String getName() {
        return "tx-rollback";
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.abortId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.abortId) {
            Value reason = pluginConnection.getEntities().get(object);
            throw new TxRollbackException(reason.stringValue());
        }
        return false;
    }
}

