/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiChatResponseMetadata;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.OpenAiUtils;
import dev.langchain4j.model.openai.internal.ParsedAndRawResponse;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionRequest;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionResponse;
import dev.langchain4j.model.openai.spi.OpenAiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class OpenAiChatModel
implements ChatModel {
    private final OpenAiClient client;
    private final Integer maxRetries;
    private final OpenAiChatRequestParameters defaultRequestParameters;
    private final String responseFormatString;
    private final Set<Capability> supportedCapabilities;
    private final boolean strictJsonSchema;
    private final boolean strictTools;
    private final boolean returnThinking;
    private final List<ChatModelListener> listeners;

    public OpenAiChatModel(OpenAiChatModelBuilder builder) {
        OpenAiChatRequestParameters openAiChatRequestParameters;
        ChatRequestParameters commonParameters;
        this.client = ((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)((OpenAiClient.Builder)OpenAiClient.builder().httpClientBuilder(builder.httpClientBuilder)).baseUrl(Utils.getOrDefault(builder.baseUrl, "https://api.openai.com/v1"))).apiKey(builder.apiKey)).organizationId(builder.organizationId)).projectId(builder.projectId)).connectTimeout(Utils.getOrDefault(builder.timeout, Duration.ofSeconds(15L)))).readTimeout(Utils.getOrDefault(builder.timeout, Duration.ofSeconds(60L)))).logRequests(Utils.getOrDefault(builder.logRequests, false))).logResponses(Utils.getOrDefault(builder.logResponses, false))).logger(builder.logger)).userAgent("langchain4j-openai")).customHeaders(builder.customHeaders)).customQueryParams(builder.customQueryParams)).build();
        this.maxRetries = Utils.getOrDefault(builder.maxRetries, 2);
        if (builder.defaultRequestParameters != null) {
            OpenAiUtils.validate(builder.defaultRequestParameters);
            commonParameters = builder.defaultRequestParameters;
        } else {
            commonParameters = DefaultChatRequestParameters.EMPTY;
        }
        ChatRequestParameters chatRequestParameters = builder.defaultRequestParameters;
        OpenAiChatRequestParameters openAiParameters = chatRequestParameters instanceof OpenAiChatRequestParameters ? (openAiChatRequestParameters = (OpenAiChatRequestParameters)chatRequestParameters) : OpenAiChatRequestParameters.EMPTY;
        this.defaultRequestParameters = ((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)OpenAiChatRequestParameters.builder().modelName(Utils.getOrDefault(builder.modelName, commonParameters.modelName()))).temperature(Utils.getOrDefault(builder.temperature, commonParameters.temperature()))).topP(Utils.getOrDefault(builder.topP, commonParameters.topP()))).frequencyPenalty(Utils.getOrDefault(builder.frequencyPenalty, commonParameters.frequencyPenalty()))).presencePenalty(Utils.getOrDefault(builder.presencePenalty, commonParameters.presencePenalty()))).maxOutputTokens(Utils.getOrDefault(builder.maxTokens, commonParameters.maxOutputTokens()))).stopSequences(Utils.getOrDefault(builder.stop, commonParameters.stopSequences()))).toolSpecifications(commonParameters.toolSpecifications())).toolChoice(commonParameters.toolChoice())).responseFormat(Utils.getOrDefault(builder.responseFormat, commonParameters.responseFormat()))).maxCompletionTokens(Utils.getOrDefault(builder.maxCompletionTokens, openAiParameters.maxCompletionTokens())).logitBias(Utils.getOrDefault(builder.logitBias, openAiParameters.logitBias())).parallelToolCalls(Utils.getOrDefault(builder.parallelToolCalls, openAiParameters.parallelToolCalls())).seed(Utils.getOrDefault(builder.seed, openAiParameters.seed())).user(Utils.getOrDefault(builder.user, openAiParameters.user())).store(Utils.getOrDefault(builder.store, openAiParameters.store())).metadata(Utils.getOrDefault(builder.metadata, openAiParameters.metadata())).serviceTier(Utils.getOrDefault(builder.serviceTier, openAiParameters.serviceTier())).reasoningEffort(openAiParameters.reasoningEffort()).customParameters(openAiParameters.customParameters()).build();
        this.responseFormatString = builder.responseFormatString;
        this.supportedCapabilities = Utils.copy(builder.supportedCapabilities);
        this.strictJsonSchema = Utils.getOrDefault(builder.strictJsonSchema, false);
        this.strictTools = Utils.getOrDefault(builder.strictTools, false);
        this.returnThinking = Utils.getOrDefault(builder.returnThinking, false);
        this.listeners = Utils.copy(builder.listeners);
    }

    @Override
    public OpenAiChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    @Override
    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>(this.supportedCapabilities);
        if ("json_schema".equals(this.responseFormatString)) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    @Override
    public ChatResponse doChat(ChatRequest chatRequest) {
        OpenAiChatRequestParameters parameters = (OpenAiChatRequestParameters)chatRequest.parameters();
        OpenAiUtils.validate(parameters);
        ChatCompletionRequest openAiRequest = OpenAiUtils.toOpenAiChatRequest(chatRequest, parameters, this.strictTools, this.strictJsonSchema).build();
        ParsedAndRawResponse parsedAndRawResponse = RetryUtils.withRetryMappingExceptions(() -> this.client.chatCompletion(openAiRequest).executeRaw(), this.maxRetries);
        ChatCompletionResponse openAiResponse = (ChatCompletionResponse)parsedAndRawResponse.parsedResponse();
        OpenAiChatResponseMetadata responseMetadata = ((OpenAiChatResponseMetadata.Builder)((OpenAiChatResponseMetadata.Builder)((OpenAiChatResponseMetadata.Builder)((OpenAiChatResponseMetadata.Builder)OpenAiChatResponseMetadata.builder().id(openAiResponse.id())).modelName(openAiResponse.model())).tokenUsage(OpenAiUtils.tokenUsageFrom(openAiResponse.usage()))).finishReason(OpenAiUtils.finishReasonFrom(openAiResponse.choices().get(0).finishReason()))).created(openAiResponse.created()).serviceTier(openAiResponse.serviceTier()).systemFingerprint(openAiResponse.systemFingerprint()).rawHttpResponse(parsedAndRawResponse.rawHttpResponse()).build();
        return ChatResponse.builder().aiMessage(OpenAiUtils.aiMessageFrom(openAiResponse, this.returnThinking)).metadata(responseMetadata).build();
    }

    @Override
    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    @Override
    public ModelProvider provider() {
        return ModelProvider.OPEN_AI;
    }

    public static OpenAiChatModelBuilder builder() {
        Iterator<OpenAiChatModelBuilderFactory> iterator = ServiceHelper.loadFactories(OpenAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiChatModelBuilderFactory factory = iterator.next();
            return (OpenAiChatModelBuilder)factory.get();
        }
        return new OpenAiChatModelBuilder();
    }

    public static class OpenAiChatModelBuilder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String projectId;
        private ChatRequestParameters defaultRequestParameters;
        private String modelName;
        private Double temperature;
        private Double topP;
        private List<String> stop;
        private Integer maxTokens;
        private Integer maxCompletionTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Set<Capability> supportedCapabilities;
        private ResponseFormat responseFormat;
        private String responseFormatString;
        private Boolean strictJsonSchema;
        private Integer seed;
        private String user;
        private Boolean strictTools;
        private Boolean parallelToolCalls;
        private Boolean store;
        private Map<String, String> metadata;
        private String serviceTier;
        private Boolean returnThinking;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private Logger logger;
        private Map<String, String> customHeaders;
        private Map<String, String> customQueryParams;
        private List<ChatModelListener> listeners;

        public OpenAiChatModelBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public OpenAiChatModelBuilder defaultRequestParameters(ChatRequestParameters parameters) {
            this.defaultRequestParameters = parameters;
            return this;
        }

        public OpenAiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiChatModelBuilder modelName(OpenAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiChatModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiChatModelBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public OpenAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OpenAiChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public OpenAiChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public OpenAiChatModelBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public OpenAiChatModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public OpenAiChatModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public OpenAiChatModelBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public OpenAiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OpenAiChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = OpenAiUtils.fromOpenAiResponseFormat(responseFormat);
            this.responseFormatString = responseFormat;
            return this;
        }

        public OpenAiChatModelBuilder supportedCapabilities(Set<Capability> supportedCapabilities) {
            this.supportedCapabilities = supportedCapabilities;
            return this;
        }

        public OpenAiChatModelBuilder supportedCapabilities(Capability ... supportedCapabilities) {
            return this.supportedCapabilities(new HashSet<Capability>(Arrays.asList(supportedCapabilities)));
        }

        public OpenAiChatModelBuilder strictJsonSchema(Boolean strictJsonSchema) {
            this.strictJsonSchema = strictJsonSchema;
            return this;
        }

        public OpenAiChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OpenAiChatModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiChatModelBuilder strictTools(Boolean strictTools) {
            this.strictTools = strictTools;
            return this;
        }

        public OpenAiChatModelBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public OpenAiChatModelBuilder store(Boolean store) {
            this.store = store;
            return this;
        }

        public OpenAiChatModelBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public OpenAiChatModelBuilder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public OpenAiChatModelBuilder returnThinking(Boolean returnThinking) {
            this.returnThinking = returnThinking;
            return this;
        }

        public OpenAiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiChatModelBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public OpenAiChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiChatModelBuilder customQueryParams(Map<String, String> customQueryParams) {
            this.customQueryParams = customQueryParams;
            return this;
        }

        public OpenAiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OpenAiChatModel build() {
            return new OpenAiChatModel(this);
        }
    }
}

