/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.filesystem;

import com.ontotext.metamodel.storage.ConfigurationManager;
import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.Resettable;
import java.util.Objects;
import java.util.Optional;

public class ConfigurationSomlSchemaIdStorage
implements SomlSchemaIdStorage,
Resettable {
    private static final String SCHEMA_ID = "schema.id";
    private final ConfigurationManager configurationManager;

    public ConfigurationSomlSchemaIdStorage(ConfigurationManager configurationManager) {
        this.configurationManager = Objects.requireNonNull(configurationManager, "ConfigurationManager is required!");
    }

    @Override
    public Optional<String> getId() {
        return Optional.ofNullable(this.configurationManager.get(SCHEMA_ID));
    }

    @Override
    public void setId(String id) {
        this.configurationManager.set(SCHEMA_ID, id);
    }

    public HealthResult runHealthCheck() {
        if (this.configurationManager.isWriteable()) {
            return new HealthResult("config-id-manager", HealthResult.Status.GREEN);
        }
        return new HealthResult("config-id-manager", HealthResult.Status.YELLOW, "Store is not writeable");
    }

    public void reset() {
        this.setId(null);
    }
}

