/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.extensions.OperationResponse;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaEntity {
    private String id;
    private String schemaId;
    private SomlSchema somlSchema;
    private String originalDefinition;
    private Long lastModified;
    private Set<String> serviceAddresses;
    private Boolean active;
    private String label;
    private String description;
    private int objectsCount;
    private int propertiesCount;
    private int warnings;
    private int errors;
    private List<String> warningsMessage;
    private List<String> errorsMessage;
    private String endpointCreationType;

    public SchemaEntity() {
    }

    public SchemaEntity(String originalDefinition) {
        this.originalDefinition = originalDefinition;
        this.schemaId = SomlSchemaParser.getId((String)originalDefinition);
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void overrideSchemaId(String schemaId) {
        this.setSchemaId(schemaId);
        if (this.originalDefinition != null) {
            this.originalDefinition = SomlSchemaParser.setId((String)schemaId, (String)this.originalDefinition);
        }
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public SomlSchema getSomlSchema() {
        return this.somlSchema;
    }

    public SchemaEntity setSomlSchema(SomlSchema somlSchema) {
        this.somlSchema = somlSchema;
        return this;
    }

    public String getOriginalDefinition() {
        return this.originalDefinition;
    }

    public void setOriginalDefinition(String originalDefinition) {
        this.originalDefinition = originalDefinition;
    }

    public String toString() {
        return "SchemaEntity{id='" + this.id + "', schemaId='" + this.schemaId + "', lastModified=" + this.lastModified + ", serviceAddresses=" + String.valueOf(this.serviceAddresses) + ", label='" + this.label + "', description='" + this.description + "', objects_count=" + this.objectsCount + ", properties_count=" + this.propertiesCount + ", warnings=" + this.warnings + ", errors=" + this.errors + ", warningsMessage='" + String.valueOf(this.warningsMessage) + "', errorsMessage='" + String.valueOf(this.errorsMessage) + "', endpointCreationType='" + this.endpointCreationType + "'}";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getServiceAddresses() {
        if (this.serviceAddresses == null) {
            return Collections.emptySet();
        }
        return this.serviceAddresses;
    }

    public void addServiceAddress(String serviceAddress) {
        if (this.serviceAddresses == null) {
            this.serviceAddresses = new LinkedHashSet<String>();
        }
        this.serviceAddresses.add(serviceAddress);
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getObjectsCount() {
        return this.objectsCount;
    }

    public void setObjectsCount(int objectsCount) {
        this.objectsCount = objectsCount;
    }

    public int getPropertiesCount() {
        return this.propertiesCount;
    }

    public void setPropertiesCount(int propertiesCount) {
        this.propertiesCount = propertiesCount;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public List<String> getWarningsMessage() {
        return this.warningsMessage;
    }

    public void setWarningsMessage(List<String> warningsMessage) {
        this.warningsMessage = warningsMessage;
    }

    public List<String> getErrorsMessage() {
        return this.errorsMessage;
    }

    public void setErrorsMessage(List<String> errorsMessage) {
        this.errorsMessage = errorsMessage;
    }

    public static SchemaEntity createSchemaEntity(String schema, SomlSchema somlSchema, OperationResponse validationResult, String creationType) {
        SchemaEntity entity = new SchemaEntity(schema);
        entity.setSomlSchema(somlSchema);
        entity.setLabel(somlSchema.getLabel());
        entity.setDescription(somlSchema.getDescription());
        Shapes objects = somlSchema.getObjects();
        entity.setObjectsCount((int)objects.values().stream().filter(obj -> !obj.isSystem()).count());
        entity.setPropertiesCount((int)objects.values().stream().filter(obj -> !obj.isSystem()).flatMap(obj -> obj.getProps().values().stream().map(PropertyShape::getName)).distinct().count());
        entity.setWarningsMessage(validationResult.getWarningMessages().stream().map(Objects::toString).distinct().collect(Collectors.toList()));
        entity.setWarnings(entity.getWarningsMessage().size());
        entity.setErrorsMessage(validationResult.getErrors().stream().map(Objects::toString).distinct().collect(Collectors.toList()));
        entity.setErrors(entity.getErrorsMessage().size());
        entity.setEndpointCreationType(creationType);
        return entity;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getEndpointCreationType() {
        return this.endpointCreationType;
    }

    public void setEndpointCreationType(String endpointCreationType) {
        this.endpointCreationType = endpointCreationType;
    }
}

