/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.ServiceIdentity;
import com.ontotext.soaas.common.HostnameUtils;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class LocalApplicationNameProvider
implements ServiceIdentity {
    private static final String SCHEME_SEPARATOR = "://";
    private static final String HTTP = "http";
    private final String instanceName;
    private final String address;
    private final String serviceAddress;

    public LocalApplicationNameProvider(int applicationPort) {
        this(null, HostnameUtils.getHostname(), "http://" + HostnameUtils.getHostnameWithPort((int)applicationPort));
    }

    LocalApplicationNameProvider(String instanceName, String address, String serviceAddress) {
        this.instanceName = instanceName;
        this.address = address;
        this.serviceAddress = serviceAddress;
    }

    public static ServiceIdentity create(String name, String scheme, String address, int port) {
        Object addressWithPort;
        String uriScheme = Objects.toString(scheme, HTTP);
        if (StringUtils.isBlank((CharSequence)address)) {
            address = HostnameUtils.getHostname();
            addressWithPort = uriScheme + SCHEME_SEPARATOR + HostnameUtils.getHostnameWithPort((int)port);
        } else {
            try {
                URIBuilder builder;
                if (!address.contains(SCHEME_SEPARATOR)) {
                    String addressCopy = uriScheme + SCHEME_SEPARATOR + address;
                    builder = new URIBuilder(addressCopy);
                } else {
                    builder = new URIBuilder(address);
                }
                address = builder.getHost();
                if (builder.getPort() < 0 && port > 0 && (StringUtils.isBlank((CharSequence)builder.getPath()) || "/".equals(builder.getPath()))) {
                    builder.setPort(port);
                }
                addressWithPort = builder.build().toString();
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("The specified service address is not valid", use);
            }
        }
        return new LocalApplicationNameProvider(name, address, (String)addressWithPort);
    }

    @Override
    public String getName() {
        if (this.instanceName == null) {
            return this.getAddress();
        }
        return this.instanceName;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getServiceAddress() {
        return this.serviceAddress;
    }
}

