/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage;

import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.storage.LogEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public interface TransactionLog {
    public static final String TRANSACTION_LOG_DIR = "graphdb.raft.transaction.log.dir";
    public static final String RAFT_FOLDER = "raft";
    public static final String SYSTEM_UPDATE = "SYSTEM";
    public static final String CONFIG_CHANGE = "CONFIG_CHANGE";
    public static final String RECOVERY = "RECOVERY";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String SECONDARY = "SECONDARY";
    public static final String IGNORED = "IGNORED";
    public static final String LLM_UPDATE = "LLM";
    public static final int SYSTEM_CHANNEL = 0;
    public static final int HEARTBEAT = -1;
    public static final int CONFIG_CHANGE_CHANNEL = -2;
    public static final int NO_CHANNEL = -3;
    public static final int DELETED_CHANNEL = -4;
    public static final int RECOVERY_CHANNEL = -5;
    public static final int TRUNCATE_CHANNEL = -6;
    public static final int SYSTEM_HEARTBEAT = -7;
    public static final int SECONDARY_CHANNEL = -8;
    public static final int LLM_CHANNEL = -9;

    public void initialize();

    public void shutdown(boolean var1);

    public int putChannelIfAbsent(String var1);

    public void removeChannel(String var1);

    public Map<String, Integer> getChannelMapping();

    public String getChannel(int var1);

    public int getChannelId(String var1);

    public Map<String, Integer> getChannelIds();

    public void beginBatchingStream();

    public void endBatchingStream();

    public void batchTransactionChannels(OutputStream var1, long var2, long var4) throws IOException;

    public long getLastLogIndex();

    public long getValidLogCheckpoint();

    public long getEntryOffset();

    default public long getNextLogIndex() {
        return this.getLastLogIndex() + 1L;
    }

    public long getLastLogTerm();

    public LogEntry getLastLog();

    public void restoreRepositoryIndex(int var1);

    public int getCurrentRepoIndex();

    public void setLogStatus(long var1, LogEntry.Status var3);

    public LogEntry fetchLogEntry(long var1);

    public LogEntry.Status fetchEntryStatus(long var1);

    public LogEntry appendLogEntry(AppendEntry var1);

    public LogEntry appendConfigLogEntry(ConfigEntry var1);

    public long appendLogEntryStream(AppendEntry var1);

    public long appendLogEntryStream(BackupEntry var1);

    public LogEntry commitLogEntryStream(long var1, String var3);

    public void rollbackLogEntryStream(long var1);

    public OutputStream beginTransactionRecord(String var1, AtomicBoolean var2);

    public void rollbackTransactionRecord(String var1);

    public LogEntry commitTransactionRecord(String var1, AppendEntry var2);

    public OutputStream beginBackupRecord(List<String> var1, boolean var2);

    public LogEntry commitBackupRecord(AppendEntry var1);

    public void rollbackBackupRecord();

    public void validateEntry(LogEntry var1);

    public long getLogEntryTerm(long var1);

    public void verifyLastChannelEntries(Consumer<LogEntry> var1);

    public long getLastValidLog();

    public void lockChannel(int var1);

    public void unlockChannel(int var1);

    public void lockTransactionLog();

    public void unlockTransactionLog();

    public void delete();

    public void beginTruncate();

    public LogEntry commitTruncate(AppendEntry var1);

    public void rollbackTruncate();

    public boolean isEveryChannelValid();

    public boolean isLocked();

    public AtomicLong getSize();
}

