/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage;

import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.VerifyResponse;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LogEntry {
    public static final byte SECONDARY_CREATE = 1;
    public static final byte SECONDARY_DELETE = 2;
    public static final byte SECONDARY_UPDATE = 3;
    public static final byte ADD_TAG = 4;
    public static final byte REMOVE_TAG = 5;

    public InputStream getDataStream();

    public String getFingerprint();

    public List<NodeInfo> getNewConfig();

    public List<NodeInfo> getOldConfig();

    public boolean isMembershipConfigEntry();

    public Map<String, Number> getConfigParameters();

    public String getRepository();

    public long getIndex();

    public void setStatus(Status var1);

    public Status getStatus();

    public int getChannel();

    public long getTerm();

    public List<String> getAffectedChannels();

    public boolean clearAllChannels();

    public long getSize();

    default public long getDataSize() {
        throw new UnsupportedOperationException();
    }

    public byte getSecondaryType();

    public static enum Status implements Serializable
    {
        CREATED(1),
        PROCESSING(2),
        PROCESSED(3),
        VALID(4);

        private final byte code;
        private static final Map<String, Status> MAP;
        private static final List<Status> CODE_LIST;

        private Status(byte code) {
            this.code = code;
        }

        public byte getStatusCode() {
            return this.code;
        }

        public static Status of(VerifyResponse.Status entryType) {
            return MAP.get(entryType.name());
        }

        public static Status fromCode(byte code) {
            if (code < 1) {
                throw new TransactionLogException("Unable to parse log entry status code: " + code);
            }
            return CODE_LIST.get(code - 1);
        }

        static {
            MAP = new HashMap<String, Status>();
            CODE_LIST = new ArrayList<Status>();
            for (Status status : Status.values()) {
                MAP.put(status.name(), status);
                CODE_LIST.add(status);
            }
        }
    }
}

